## Calculate Spearmans correlation with dnMis-Epi genes during the vRG-to-IPC transition at GW10.

data_gene <- scan("../gene_set/dnMis-Epi.txt", what = "character", sep = "\t")

data_gene_1 <- scan("../expression/NPCs/gene_T_1.txt", what = "character", sep = "\t")

data_intersect <- intersect(data_gene, data_gene_1)

data_intersect <- sort(data_intersect)

write.table(data_intersect, file = "gene_Epi.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

data_setdiff <- setdiff(data_gene_1, data_gene)

data_setdiff <- sort(data_setdiff)

write.table(data_setdiff, file = "gene_not_Epi.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

data_expression <- read.table("../expression/transition/GSE_vRGs_IPCs_GW10_high.txt", sep = "\t", colClasses = "character")

data_gene <- read.table("gene_Epi.txt", sep = "\t", colClasses = "character")

data_expression_1 <- merge(data_expression, data_gene, by = 1)

write.table(data_expression_1[,1], file = "gene_Epi_1.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

write.table(data_expression_1[,2:ncol(data_expression_1)], file = "expression_Epi.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

data_gene <- read.table("gene_not_Epi.txt", sep = "\t", colClasses = "character")

data_expression_1 <- merge(data_expression, data_gene, by = 1)

write.table(data_expression_1[,1], file = "gene_not_Epi_1.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

write.table(data_expression_1[,2:ncol(data_expression_1)], file = "expression_not_Epi.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

data_expression <- read.table("expression_Epi.txt", sep = "\t")

data_expression <- t(data_expression)

data_cor <- cor(data_expression, method = "spearman")

diag(data_cor) <- NA

data_cor_1 <- rowMeans(data_cor, na.rm = TRUE)

data_gene <- scan("gene_Epi_1.txt", what = "character", sep = "\t")

data_cor_2 <- data.frame(data_gene, data_cor_1)

write.table(data_cor_2, file = "cor_not_Epi.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

data_expression <- read.table("expression_not_Epi.txt", sep = "\t")

data_expression <- t(data_expression)

data_expression_1 <- read.table("expression_Epi.txt", sep = "\t")

data_expression_1 <- t(data_expression_1)

data_cor <- cor(data_expression, data_expression_1, method = "spearman")

data_cor_1 <- rowMeans(data_cor, na.rm = TRUE)

data_gene <- scan("gene_not_Epi_1.txt", what = "character", sep = "\t")

data_cor_2 <- data.frame(data_gene, data_cor_1)

write.table(data_cor_2, file = "cor_not_Epi.txt", append = TRUE, quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)
