## GO expression increase analysis during the vRG-to-IPC transition at GW10.

data_FC <- read.table("FC_vRG_IPC.txt", sep = "\t")

data_FC_1 <- data_FC[,2]

data_GO <- scan("GO_3.txt", what = "character", sep = "\t")

data_result <- matrix(data = NA, nrow = length(data_GO), ncol = 4)

for (i in 1:length(data_GO))
{
    file_name <- paste("./GO/", ".txt", sep = data_GO[i])

    file_name <- gsub(":", "_", file_name)

    data_GO_1 <- read.table(file_name, sep = "\t")

    data_FC_2 <- merge(data_FC, data_GO_1, by = 1)

    data_FC_2 <- data_FC_2[,2]

    data_test <- wilcox.test(data_FC_2, data_FC_1, alternative = "greater")

    data_result[i,1] <- mean(data_FC_2)

    data_result[i,2] <- sd(data_FC_2)/sqrt(length(data_FC_2))

    data_result[i,3] <- data_test$p.value
}

data_result[,4] <- p.adjust(data_result[,3], method = "BH")

data_result_1 <- data.frame(data_GO, data_result)

write.table(data_result_1, file = "FC_vRG_IPC_1.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

data_GO <- read.table("../GO_overlap/GO.txt", sep = "\t", quote = "", colClasses = "character", comment.char = "")

data_FC <- read.table("FC_vRG_IPC_1.txt", sep = "\t", colClasses = "character")

data_FC_1 <- merge(data_GO, data_FC, by = 1, all.y = TRUE)

write.table(data_FC_1, file = "FC_vRG_IPC_2.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)
