## Plot overlap between CHD8-activated/-repressed genes and ASD genes with at least one dnLoF mutation.

data_gene_1 <- scan("gene_T_1.txt", what = "character", sep = "\t")

data_gene_2 <- scan("../gene_set/ASD_all_lof.txt", what = "character", sep = "\t")

data_intersect <- intersect(data_gene_1, data_gene_2)

data_intersect <- sort(data_intersect)

write.table(data_intersect, file = "gene_ASD.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

data_gene_1 <- scan("gene_ASD.txt", what = "character", sep = "\t")

data_gene_2 <- scan("gene_T125_down.txt", what = "character", sep = "\t")

data_intersect <- intersect(data_gene_1, data_gene_2)

data_intersect <- sort(data_intersect)

write.table(data_intersect, file = "gene_ASD_intersect_1.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

data_gene_2 <- scan("gene_T145_down.txt", what = "character", sep = "\t")

data_intersect <- intersect(data_gene_1, data_gene_2)

data_intersect <- sort(data_intersect)

write.table(data_intersect, file = "gene_ASD_intersect_2.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

data_gene_2 <- scan("gene_T175_down.txt", what = "character", sep = "\t")

data_intersect <- intersect(data_gene_1, data_gene_2)

data_intersect <- sort(data_intersect)

write.table(data_intersect, file = "gene_ASD_intersect_3.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

data_gene_2 <- scan("gene_T21_down.txt", what = "character", sep = "\t")

data_intersect <- intersect(data_gene_1, data_gene_2)

data_intersect <- sort(data_intersect)

write.table(data_intersect, file = "gene_ASD_intersect_4.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

data_gene_2 <- scan("gene_T77_down.txt", what = "character", sep = "\t")

data_intersect <- intersect(data_gene_1, data_gene_2)

data_intersect <- sort(data_intersect)

write.table(data_intersect, file = "gene_ASD_intersect_5.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

data_gene_2 <- scan("gene_T125_up.txt", what = "character", sep = "\t")

data_intersect <- intersect(data_gene_1, data_gene_2)

data_intersect <- sort(data_intersect)

write.table(data_intersect, file = "gene_ASD_intersect_6.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

data_gene_2 <- scan("gene_T145_up.txt", what = "character", sep = "\t")

data_intersect <- intersect(data_gene_1, data_gene_2)

data_intersect <- sort(data_intersect)

write.table(data_intersect, file = "gene_ASD_intersect_7.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

data_gene_2 <- scan("gene_T175_up.txt", what = "character", sep = "\t")

data_intersect <- intersect(data_gene_1, data_gene_2)

data_intersect <- sort(data_intersect)

write.table(data_intersect, file = "gene_ASD_intersect_8.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

data_gene_2 <- scan("gene_T21_up.txt", what = "character", sep = "\t")

data_intersect <- intersect(data_gene_1, data_gene_2)

data_intersect <- sort(data_intersect)

write.table(data_intersect, file = "gene_ASD_intersect_9.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

data_gene_2 <- scan("gene_T77_up.txt", what = "character", sep = "\t")

data_intersect <- intersect(data_gene_1, data_gene_2)

data_intersect <- sort(data_intersect)

write.table(data_intersect, file = "gene_ASD_intersect_10.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

data_gene_1 <- scan("gene_ASD.txt", what = "character", sep = "\t")

data_gene_2 <- scan("gene_T125_down.txt", what = "character", sep = "\t")

data_union <- union(data_gene_1, data_gene_2)

data_union <- sort(data_union)

write.table(data_union, file = "gene_ASD_union_1.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

data_gene_2 <- scan("gene_T145_down.txt", what = "character", sep = "\t")

data_union <- union(data_gene_1, data_gene_2)

data_union <- sort(data_union)

write.table(data_union, file = "gene_ASD_union_2.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

data_gene_2 <- scan("gene_T175_down.txt", what = "character", sep = "\t")

data_union <- union(data_gene_1, data_gene_2)

data_union <- sort(data_union)

write.table(data_union, file = "gene_ASD_union_3.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

data_gene_2 <- scan("gene_T21_down.txt", what = "character", sep = "\t")

data_union <- union(data_gene_1, data_gene_2)

data_union <- sort(data_union)

write.table(data_union, file = "gene_ASD_union_4.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

data_gene_2 <- scan("gene_T77_down.txt", what = "character", sep = "\t")

data_union <- union(data_gene_1, data_gene_2)

data_union <- sort(data_union)

write.table(data_union, file = "gene_ASD_union_5.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

data_gene_2 <- scan("gene_T125_up.txt", what = "character", sep = "\t")

data_union <- union(data_gene_1, data_gene_2)

data_union <- sort(data_union)

write.table(data_union, file = "gene_ASD_union_6.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

data_gene_2 <- scan("gene_T145_up.txt", what = "character", sep = "\t")

data_union <- union(data_gene_1, data_gene_2)

data_union <- sort(data_union)

write.table(data_union, file = "gene_ASD_union_7.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

data_gene_2 <- scan("gene_T175_up.txt", what = "character", sep = "\t")

data_union <- union(data_gene_1, data_gene_2)

data_union <- sort(data_union)

write.table(data_union, file = "gene_ASD_union_8.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

data_gene_2 <- scan("gene_T21_up.txt", what = "character", sep = "\t")

data_union <- union(data_gene_1, data_gene_2)

data_union <- sort(data_union)

write.table(data_union, file = "gene_ASD_union_9.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

data_gene_2 <- scan("gene_T77_up.txt", what = "character", sep = "\t")

data_union <- union(data_gene_1, data_gene_2)

data_union <- sort(data_union)

write.table(data_union, file = "gene_ASD_union_10.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

pdf(file = "overlap_ASD.pdf", width = 8, height = 8)

data_size <- numeric(length = 10)

data_intersect <- scan("gene_ASD_intersect_1.txt", what = "character", sep = "\t")

data_size[1] <- length(data_intersect)

data_intersect <- scan("gene_ASD_intersect_2.txt", what = "character", sep = "\t")

data_size[2] <- length(data_intersect)

data_intersect <- scan("gene_ASD_intersect_3.txt", what = "character", sep = "\t")

data_size[3] <- length(data_intersect)

data_intersect <- scan("gene_ASD_intersect_4.txt", what = "character", sep = "\t")

data_size[4] <- length(data_intersect)

data_intersect <- scan("gene_ASD_intersect_5.txt", what = "character", sep = "\t")

data_size[5] <- length(data_intersect)

data_intersect <- scan("gene_ASD_intersect_6.txt", what = "character", sep = "\t")

data_size[6] <- length(data_intersect)

data_intersect <- scan("gene_ASD_intersect_7.txt", what = "character", sep = "\t")

data_size[7] <- length(data_intersect)

data_intersect <- scan("gene_ASD_intersect_8.txt", what = "character", sep = "\t")

data_size[8] <- length(data_intersect)

data_intersect <- scan("gene_ASD_intersect_9.txt", what = "character", sep = "\t")

data_size[9] <- length(data_intersect)

data_intersect <- scan("gene_ASD_intersect_10.txt", what = "character", sep = "\t")

data_size[10] <- length(data_intersect)

data_gene <- scan("gene_ASD.txt", what = "character", sep = "\t")

data_gene_1 <- scan("gene_T_1.txt", what = "character", sep = "\t")

data_size_1 <- 300*length(data_gene)/length(data_gene_1)

par(mar = c(6, 5.5, 4.5, 0))

par(mgp = c(3, 1, 0))

par(cex.axis = 2)

par(cex.lab = 2)

par(cex.main = 1.7)

barplot(data_size, width = 1, space = NULL, names.arg = NULL, beside = TRUE, horiz = FALSE, col = c(2, 2, 2, 2, 2, "#6666FF", "#6666FF", "#6666FF", "#6666FF", "#6666FF"), main = "Overlap with ASD genes", xlab = NULL, ylab = "Number of overlapping genes", xlim = NULL, ylim = c(0, 47), axes = FALSE)

par(cex.axis = 1)

axis(1, 1:10*1.2-0.5, labels = FALSE)

text(1:10*1.2-0.5, par("usr")[3]-0.5, labels = c("E12.5", "E14.5", "E17.5", "P0", "Adult", "E12.5", "E14.5", "E17.5", "P0", "Adult"), srt = 0, pos = 1, xpd = TRUE, cex = 1.4)

par(cex.axis = 2)

axis(2, c(0:9*5), c(0:9*5), las = 2)

lines(c(0, 10*1.2), c(data_size_1, data_size_1), lty = 2, lwd = 1.5)

data_size_2 <- numeric(length = 10)

data_union <- scan("gene_ASD_union_1.txt", what = "character", sep = "\t")

data_size_2[1] <- length(data_union)

data_union <- scan("gene_ASD_union_2.txt", what = "character", sep = "\t")

data_size_2[2] <- length(data_union)

data_union <- scan("gene_ASD_union_3.txt", what = "character", sep = "\t")

data_size_2[3] <- length(data_union)

data_union <- scan("gene_ASD_union_4.txt", what = "character", sep = "\t")

data_size_2[4] <- length(data_union)

data_union <- scan("gene_ASD_union_5.txt", what = "character", sep = "\t")

data_size_2[5] <- length(data_union)

data_union <- scan("gene_ASD_union_6.txt", what = "character", sep = "\t")

data_size_2[6] <- length(data_union)

data_union <- scan("gene_ASD_union_7.txt", what = "character", sep = "\t")

data_size_2[7] <- length(data_union)

data_union <- scan("gene_ASD_union_8.txt", what = "character", sep = "\t")

data_size_2[8] <- length(data_union)

data_union <- scan("gene_ASD_union_9.txt", what = "character", sep = "\t")

data_size_2[9] <- length(data_union)

data_union <- scan("gene_ASD_union_10.txt", what = "character", sep = "\t")

data_size_2[10] <- length(data_union)

data_intersect_union <- matrix(data = NA, nrow = 2, ncol = 2)

data_intersect_union[1,1] <- data_size[1]

data_intersect_union[1,2] <- length(data_gene)-data_size[1]

data_intersect_union[2,1] <- 300-data_size[1]

data_intersect_union[2,2] <- length(data_gene_1)-data_size_2[1]

data_p <- fisher.test(data_intersect_union, alternative = "greater")

data_p <- signif(data_p$p.value, digits = 2)

data_p <- paste("p", data_p, sep = "=")

text(1*1.2-0.5, data_size[1]+1, data_p, cex = 1.2)

data_intersect_union <- matrix(data = NA, nrow = 2, ncol = 2)

data_intersect_union[1,1] <- data_size[2]

data_intersect_union[1,2] <- length(data_gene)-data_size[2]

data_intersect_union[2,1] <- 300-data_size[2]

data_intersect_union[2,2] <- length(data_gene_1)-data_size_2[2]

data_p <- fisher.test(data_intersect_union, alternative = "greater")

data_p <- signif(data_p$p.value, digits = 2)

data_p <- paste("p", data_p, sep = "=")

text(2*1.2-0.5, data_size[2]+1, data_p, cex = 1.2)

data_intersect_union <- matrix(data = NA, nrow = 2, ncol = 2)

data_intersect_union[1,1] <- data_size[3]

data_intersect_union[1,2] <- length(data_gene)-data_size[3]

data_intersect_union[2,1] <- 300-data_size[3]

data_intersect_union[2,2] <- length(data_gene_1)-data_size_2[3]

data_p <- fisher.test(data_intersect_union, alternative = "greater")

data_p <- signif(data_p$p.value, digits = 2)

data_p <- paste("p", data_p, sep = "=")

text(3*1.2-0.5, data_size[3]+1, data_p, cex = 1.2)

data_intersect_union <- matrix(data = NA, nrow = 2, ncol = 2)

data_intersect_union[1,1] <- data_size[4]

data_intersect_union[1,2] <- length(data_gene)-data_size[4]

data_intersect_union[2,1] <- 300-data_size[4]

data_intersect_union[2,2] <- length(data_gene_1)-data_size_2[4]

data_p <- fisher.test(data_intersect_union, alternative = "greater")

data_p <- signif(data_p$p.value, digits = 2)

data_p <- paste("p", data_p, sep = "=")

text(4*1.2-0.5, data_size[4]+1, data_p, cex = 1.2)

data_intersect_union <- matrix(data = NA, nrow = 2, ncol = 2)

data_intersect_union[1,1] <- data_size[5]

data_intersect_union[1,2] <- length(data_gene)-data_size[5]

data_intersect_union[2,1] <- 300-data_size[5]

data_intersect_union[2,2] <- length(data_gene_1)-data_size_2[5]

data_p <- fisher.test(data_intersect_union, alternative = "greater")

data_p <- signif(data_p$p.value, digits = 2)

data_p <- paste("p", data_p, sep = "=")

text(5*1.2-0.5, data_size[5]+1, data_p, cex = 1.2)

data_intersect_union <- matrix(data = NA, nrow = 2, ncol = 2)

data_intersect_union[1,1] <- data_size[6]

data_intersect_union[1,2] <- length(data_gene)-data_size[6]

data_intersect_union[2,1] <- 300-data_size[6]

data_intersect_union[2,2] <- length(data_gene_1)-data_size_2[6]

data_p <- fisher.test(data_intersect_union, alternative = "greater")

data_p <- signif(data_p$p.value, digits = 2)

data_p <- paste("p", data_p, sep = "=")

text(6*1.2-0.5, data_size[6]+1, data_p, cex = 1.2)

data_intersect_union <- matrix(data = NA, nrow = 2, ncol = 2)

data_intersect_union[1,1] <- data_size[7]

data_intersect_union[1,2] <- length(data_gene)-data_size[7]

data_intersect_union[2,1] <- 300-data_size[7]

data_intersect_union[2,2] <- length(data_gene_1)-data_size_2[7]

data_p <- fisher.test(data_intersect_union, alternative = "greater")

data_p <- signif(data_p$p.value, digits = 2)

data_p <- paste("p", data_p, sep = "=")

text(7*1.2-0.5, data_size[7]+1, data_p, cex = 1.2)

data_intersect_union <- matrix(data = NA, nrow = 2, ncol = 2)

data_intersect_union[1,1] <- data_size[8]

data_intersect_union[1,2] <- length(data_gene)-data_size[8]

data_intersect_union[2,1] <- 300-data_size[8]

data_intersect_union[2,2] <- length(data_gene_1)-data_size_2[8]

data_p <- fisher.test(data_intersect_union, alternative = "greater")

data_p <- signif(data_p$p.value, digits = 2)

data_p <- paste("p", data_p, sep = "=")

text(8*1.2-0.5, data_size[8]+1, data_p, cex = 1.2)

data_intersect_union <- matrix(data = NA, nrow = 2, ncol = 2)

data_intersect_union[1,1] <- data_size[9]

data_intersect_union[1,2] <- length(data_gene)-data_size[9]

data_intersect_union[2,1] <- 300-data_size[9]

data_intersect_union[2,2] <- length(data_gene_1)-data_size_2[9]

data_p <- fisher.test(data_intersect_union, alternative = "greater")

data_p <- signif(data_p$p.value, digits = 2)

data_p <- paste("p", data_p, sep = "=")

text(9*1.2-0.5, data_size[9]+1, data_p, cex = 1.2)

data_intersect_union <- matrix(data = NA, nrow = 2, ncol = 2)

data_intersect_union[1,1] <- data_size[10]

data_intersect_union[1,2] <- length(data_gene)-data_size[10]

data_intersect_union[2,1] <- 300-data_size[10]

data_intersect_union[2,2] <- length(data_gene_1)-data_size_2[10]

data_p <- fisher.test(data_intersect_union, alternative = "greater")

data_p <- signif(data_p$p.value, digits = 2)

data_p <- paste("p", data_p, sep = "=")

text(10*1.2-0.5, data_size[10]+1, data_p, cex = 1.2)

dev.off()
