## Plot Spearmans correlation between CHD8-activated/-repressed target genes and CHD8 during the vRG-to-IPC transition at GW10.

library(ggplot2)

column_name <- c("Cor", "Type")

write.table(t(column_name), file = "cor_vRG_IPC_GW10.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

data_cor <- vector(mode = "list", length = 3)

data_expression <- read.table("cor_vRG_IPC_down.txt", sep = "\t")

data_expression <- data_expression[,2]

data_gene_set <- rep("CHD8-activated", length(data_expression))

data_cor_1 <- data.frame(data_expression, data_gene_set)

write.table(data_cor_1, file = "cor_vRG_IPC_GW10.txt", append = TRUE, quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

data_cor[[1]] <- data_expression

data_expression <- read.table("cor_vRG_IPC_up.txt", sep = "\t")

data_expression <- data_expression[,2]

data_gene_set <- rep("CHD8-repressed", length(data_expression))

data_cor_1 <- data.frame(data_expression, data_gene_set)

write.table(data_cor_1, file = "cor_vRG_IPC_GW10.txt", append = TRUE, quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

data_cor[[2]] <- data_expression

data_expression <- read.table("cor_vRG_IPC_all.txt", sep = "\t")

data_expression <- data_expression[,2]

data_gene_set <- rep("Background", length(data_expression))

data_cor_1 <- data.frame(data_expression, data_gene_set)

write.table(data_cor_1, file = "cor_vRG_IPC_GW10.txt", append = TRUE, quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

data_cor[[3]] <- data_expression

data_test <- wilcox.test(data_cor[[1]], data_cor[[3]], alternative = "greater")

data_p <- signif(data_test$p.value, digits = 2)

data_p <- paste("p", data_p, sep = "=")

data_test <- wilcox.test(data_cor[[2]], data_cor[[3]], alternative = "less")

data_p_1 <- signif(data_test$p.value, digits = 2)

data_p_1 <- paste("p", data_p_1, sep = "=")

data_cor_2 <- read.table("cor_vRG_IPC_GW10.txt", header = TRUE, sep = "\t")

data_plot <- ggplot(data_cor_2, aes(x = factor(Type), y = Cor, colour = Type, fill = Type))

data_plot + geom_violin(trim = FALSE) +

        theme_classic() +

        theme(legend.position = "none") +

        scale_colour_manual(values = c("gray60", 2, "#6666FF")) +

        scale_fill_manual(values = c("gray60", 2, "#6666FF")) +

        stat_summary(fun.y = median, geom = "point", colour = 1, size = 3) +

        scale_x_discrete(limits = c("CHD8-activated", "CHD8-repressed", "Background")) +

        scale_y_continuous(breaks = c(-3:5/5), limits = c(-0.6, 1)) +

        labs(title = "vRG -> IPCs (GW10)", x = "", y = "Spearmans correlation with CHD8") +

        theme(axis.text.x = element_text(size = 20, hjust = 1, vjust = 1, angle = 45), axis.text.y = element_text(size = 25)) +

        theme(plot.title = element_text(face = "bold", size = 20), axis.title.y = element_text(size = 25, vjust = 0.4)) +

        geom_segment(aes(x = 1, y = 1-1.6*0.04, xend = 3, yend = 1-1.6*0.04), colour = 1) +

        geom_text(x = 2, y = 1, label = data_p, colour = 1, size = 6) +

        geom_segment(aes(x = 2, y = 1-1.6*0.12, xend = 3, yend = 1-1.6*0.12), colour = 1) +

        geom_text(x = 2.5, y = 1-1.6*0.08, label = data_p_1, colour = 1, size = 6) +

        geom_segment(aes(x = 0.5, y = median(data_cor[[3]]), xend = 3.5, yend = median(data_cor[[3]])), colour = 1, linetype = 2)

ggsave(file = "cor_vRG_IPC_GW10.pdf", width = 4, height = 8)
