## Calculate Spearmans correlation with CHD8 during the vRG-to-IPC transition at GW10.

data_gene <- scan("gene_T_1.txt", what = "character", sep = "\t")

data_gene_1 <- "57680"

data_gene_2 <- setdiff(data_gene, data_gene_1)

data_gene_2 <- sort(data_gene_2)

write.table(data_gene_1, file = "gene_CHD8.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

write.table(data_gene_2, file = "gene_not_CHD8.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

data_expression <- read.table("../expression/transition/GSE_vRGs_IPCs_GW10_high.txt", sep = "\t", colClasses = "character")

data_gene <- read.table("gene_CHD8.txt", sep = "\t", colClasses = "character")

data_expression_1 <- merge(data_expression, data_gene, by = 1)

write.table(data_expression_1[,2:ncol(data_expression_1)], file = "expression_CHD8.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

data_gene <- read.table("gene_not_CHD8.txt", sep = "\t", colClasses = "character")

data_expression_1 <- merge(data_expression, data_gene, by = 1)

write.table(data_expression_1[,1], file = "gene_not_CHD8_1.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

write.table(data_expression_1[,2:ncol(data_expression_1)], file = "expression_not_CHD8.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

data_expression <- read.table("expression_not_CHD8.txt", sep = "\t")

data_expression <- t(data_expression)

data_expression_1 <- read.table("expression_CHD8.txt", sep = "\t")

data_expression_1 <- t(data_expression_1)

data_cor <- cor(data_expression, data_expression_1, method = "spearman")

data_gene <- scan("gene_not_CHD8_1.txt", what = "character", sep = "\t")

data_cor_1 <- data.frame(data_gene, data_cor)

write.table(data_cor_1, file = "cor_not_CHD8.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)
