setwd("~/brainmap/seurat")
library(Seurat)
library(squash)
library(dplyr)
library(clusterProfiler)
library(gplots)
library(viridis)
library(RColorBrewer)
library(ggplot2)

regions <- c("acc","cn","cer")
species <- c("H","C","B","M")

load("integrated.nomito.RData")

ct <- c("In","Ex","Sn","Pur","OPC","Ast","OD","CR","MG","VEC","Gr")
#ct <- unique(markers[,"Type"])

avgs <- list()
cell.types <- list()
ct.ids <- list()
for (r in regions){
  markers <- as.matrix(read.table("markers_3sets.txt",header=T,sep="\t"))
  markers <- markers[markers[,3] %in% rownames(rlist[[r]]@assays$RNA@data),]
  cell.types[[r]] <- unique(markers[,4])
  cell.types[[r]] <- ct[ct %in% cell.types[[r]]]
  avg <- c()
  for (i in cell.types[[r]]){
    gene.set <- markers[markers[,4]==i,3]
    print(i)
    # Get mean expression of genes of interest per cell
    mtx <- rlist[[r]]@assays$RNA@data[c(gene.set,gene.set),]
    # Add mean expression values in ???object@meta.data$gene.set.score???
    rlist[[r]][[i]] <- log10(Matrix::colMeans(mtx)+0.001)
    print(min(rlist[[r]][[i]]))
    print(max(rlist[[r]][[i]]))
    # Get mean expression of genes of interest over cells in each cluster
    avg.ct <- c()
    for (cl in unique(rlist[[r]]@active.ident)){
      avg.ct <- cbind(avg.ct, Matrix::rowMeans(mtx[,rlist[[r]]@active.ident==cl]))
    }
    dimnames(avg.ct)[[1]] <- c(gene.set,gene.set)
    dimnames(avg.ct)[[2]] <- unique(rlist[[r]]@active.ident)
    avg <- rbind(avg, avg.ct)
  }
  avg <- avg[unique(rownames(avg)),]
  avg <- log10(avg+0.001)
  
  symb <- c()
  for(i in 1:nrow(avg)){
    gE <- rownames(avg)[i]
    gS <- gE
    try(gS <- bitr(gE, fromType="ENSEMBL", toType="SYMBOL", OrgDb="org.Hs.eg.db")$SYMBOL[1])
    symb <- c(symb,gS)
  }
  dimnames(avg)[[1]] <- symb
  print(avg)
  
  ord <- apply(avg,2,which.max)
  ids <- sapply(rownames(avg)[ord],function (x) markers[markers[,2]==x&markers[,4] %in% cell.types[[r]],4])
  ids <- paste(ids,names(ord))
  names(ids) <- names(ord)
  ct.ids[[r]] <- ids
  dimnames(avg)[[2]] <- ids
  avg <- avg[,order(ord)]
  
  avg[10^avg>1] <- log10(1)
  avgs[[r]] <- avg
}
save(ct.ids,file="ct.ids.nomito.RData")
save(avgs,file="avgs.nomito.RData")

markers <- as.matrix(read.table("markers_3sets.txt",header=T,sep="\t"))
markers <- markers[markers[,3] %in% unlist(lapply(rlist, function (x) rownames(x@assays$RNA@data))),]

expressed.markers <- c()
for (i in ct){
  gene.set <- markers[markers[,4]==i,3]
  for(j in gene.set){
    gS <- bitr(j, fromType="ENSEMBL", toType="SYMBOL", OrgDb="org.Hs.eg.db")$SYMBOL[1]
    expressed.markers <- c(expressed.markers,gS)
  }
}
expressed.markers

combined <- matrix(NA,sum(unlist(lapply(avgs,ncol))),length(expressed.markers))
dimnames(combined)[[1]] <- unlist(sapply(names(avgs),function (x) paste(x,colnames(avgs[[x]]))))
dimnames(combined)[[2]] <- expressed.markers
combined
for (r in regions){
  print(combined[paste(r,colnames(avgs[[r]])),rownames(avgs[[r]])])
  print(avgs[[r]])
  combined[paste(r,colnames(avgs[[r]])),rownames(avgs[[r]])] <- t(avgs[[r]])
}
combined

library(pheatmap)
pdf("avgHeatmap.nomito.pdf",width=8,height=6)
#heatmap.2(10^combined,Rowv=F,Colv=F,adjCol=c(NA,0.5),dendrogram="none",density.info="none",scale="none",trace="none",symbreaks=F,symkey=F,keysize=2,key.title="",colsep=cumsum(table(markers[,4])[ct]),col=colorRampPalette(c("lightgray","blue"))(24))
pheatmap(10^combined,
         color=colorRampPalette(c("lightgray","blue"))(48),
         #breaks=10^seq(log10(min(overlap,na.rm=T)),log10(max(overlap,na.rm=T)),length.out=91),
         border_color=NA,
         fontsize=5.75*3,
         fontsize_row=7.92*3,
         na_col="lightgray",
         gaps_row=c(6,12),
         gaps_col=cumsum(table(markers[,4])[ct]),
         cluster_rows=F,
         cluster_cols=F,
         show_rownames=T)
dev.off()

for (r in regions){
  for (i in cell.types[[r]]){
    p <- FeaturePlot(object = rlist[[r]], features = i)
    p$data <- p$data[order(p$data[[3]]),]
    
    max.exp <- max(p$data[[3]])
    p$layers[[1]]$mapping$fill <- p$layers[[1]]$mapping$colour
    bg <- rgb(0.9,0.9,0.9)
    
    png(paste0("nomito/",r,".",i,".nolegend.png"),res=600,pointsize=5.75,width=1500,height=1700)
    p <- p + scale_color_gradientn(colours = c(bg, "blue"), guide = F, limits = c(-3, max.exp), na.value = bg) + scale_fill_gradientn(colours = c(bg, "blue"), name = expression(atop(Expression, (log))), limits = c(-3, max.exp), na.value = bg) + theme_void() + theme(legend.position="none")
    p$layers[[1]]$aes_params$size = 0.001
    print(p)
    dev.off()
  }
}

pbmc.markers <- list()
for (r in regions){
  # find markers for every cluster compared to all remaining cells, report
  # only the positive ones
  pbmc.markers[[r]] <- FindAllMarkers(object = rlist[[r]], assay="RNA", only.pos = TRUE, test.use = "wilcox", min.pct = 0, return.thresh = 1)
}

save(pbmc.markers,file="pbmc.markers.nomito.RData")


top10 <- list()
for (r in regions){
    # find markers for every cluster compared to all remaining cells, report
    # only the positive ones
    top10[[r]] <- pbmc.markers[[r]] %>% group_by(cluster) %>% top_n(10, avg_logFC)
}

top10.symb <- top10
for (r in regions){
    symb <- c()
    for(i in 1:nrow(top10[[r]])){
      gE <- top10[[r]]$gene[i]
      gS <- gE
      try(gS <- bitr(gE, fromType="ENSEMBL", toType="SYMBOL", OrgDb="org.Hs.eg.db")$SYMBOL[1])
      symb <- c(symb,gS)
    }
    top10.symb[[r]]$gene <- symb
}

for (r in regions){
    gene.set <- top10[[r]]$gene
    mtx <- rlist[[r]]@assays$RNA@data[gene.set,]
    avg <- c()
    clusters <- unique(rlist[[r]]@active.ident)
    clusters <- clusters[order(as.numeric(clusters))]
    for (cl in clusters){
      avg <- cbind(avg, Matrix::rowMeans(mtx[,rlist[[r]]@active.ident==cl]))
    }
    dimnames(avg)[[1]] <- top10.symb[[r]]$gene
    dimnames(avg)[[2]] <- clusters
#    avg <- log10(avg+0.001)
    avg[avg>2.5] <- 2.5
    print(avg)
  
    pdf(paste0("heatmap.nomito.",r,".pdf"),pointsize=5.75,width=8,height=length(clusters)*2)
    pheatmap(avg,
           color=colorRampPalette(c("lightgray","blue"))(48),
           #breaks=10^seq(log10(min(overlap,na.rm=T)),log10(max(overlap,na.rm=T)),length.out=91),
           border_color=NA,
           fontsize=5.75*3,
           na_col="lightgray",
           gaps_row=(1:ncol(avg))*10,
           cluster_rows=F,
           cluster_cols=F,
           show_rownames=T)
    dev.off()
}
