setwd("~/brainmap/seurat")
library(Seurat)
library(squash)
library(dplyr)
library(clusterProfiler)
library(DOSE)
library(pheatmap)
library(viridis)

load("integrated.mapsep.RData")
load("cells.mapsep.RData")

regions <- c("acc","cn","cer")
species <- c("H","C","B","M")

de <- list()
for (r in regions){
  de[[r]] <- list()
  ident <- rlist[[r]]@active.ident
  for (i in unique(ident)){
    ident.i <- names(ident)[ident==i]
    H <- ident.i[grep(paste0("H","_"),ident.i)]
    M <- c(ident.i[grep(paste0("C","_"),ident.i)], ident.i[grep(paste0("B","_"),ident.i)], ident.i[grep(paste0("M","_"),ident.i)])
    de[[r]][[i]] <- FindMarkers(object = rlist[[r]]@assays$RNA@data, cells.1=H, cells.2=M, test.use = "wilcox", min.pct = 0.1, logfc.threshold=log(2))
  }
}
save(de,file="gene_lists.mapsep.RData")

ct.names <- list()
ct.names[["acc"]] <- c("AC Ex","AC In","AC Ast","AC OD","AC OPC","AC MG")
ct.names[["cn"]] <- c("CN Neu","CN OD","CN Ast","CN In","CN OPC","CN MG")
ct.names[["cer"]] <- c("CB Neu","CB In","CB Ast","CB OD")

table <- c()
for (r in regions){
  for (i in 1:length(de[[r]])){
    table <- rbind(table, cbind(as.matrix(de[[r]][[i]]),ct.names[[r]][i]))
  }
}
dimnames(table)[[2]] <- 	c("p_val","avg_logFC","pct.H","pct.O","p_val_adj","cell_type")
write.table(table,"gene_lists.txt",sep="\t")

