rregions = "acc"
#regions = "cn"
#regions = "cer"
#regions = "brainmap"
#for (regions in c("acc","cer","cn","brainmap")){

path = paste0("/uge_mnt/home/ilyak/SCrnaseq/brainmap/all_",regions,"/outs/filtered_gene_bc_matrices_mex")

cd1 = Read10X(data.dir = paste0(path,"/hg38/"))
cd2 = Read10X(data.dir = paste0(path,"/panTro5/"))
cd3 = Read10X(data.dir = paste0(path,"/panPan2/"))
cd4 = Read10X(data.dir = paste0(path,"/rheMac8/"))
cd = list(H=cd1, C=cd2, B=cd3, M=cd4)

orth <- as.matrix(read.delim("/uge_mnt/home/ilyak/SCrnaseq/brainmap/orth.sc.data.txt",header=T)) # obtained from Pasha
head(orth)
dim(orth)
ids <- list(H=orth[,1],C=orth[,1],B=orth[,1],M=orth[,1])
names(ids[["H"]]) <- orth[,5]
names(ids[["C"]]) <- orth[,6]
names(ids[["B"]]) <- orth[,7]
names(ids[["M"]]) <- orth[,8]
head(ids[["C"]])

for (i in names(ids)){
  print(dim(cd[[i]]))
  cd[[i]] <- cd[[i]][rownames(cd[[i]]) %in% names(ids[[i]]),]
  dimnames(cd[[i]])[[1]] <- ids[[i]][rownames(cd[[i]])]
  print(dim(cd[[i]]))
}

genes <- c()
for (i in names(ids)){
  tab <- table(rownames(cd[[i]]))
  genes <- c(genes,names(tab)[tab==1])
}
tab <- table(genes)
genes <- names(tab)[tab==4]
length(genes)

for (i in names(ids)){
  print(dim(cd[[i]]))
  cd[[i]] <- cd[[i]][genes,]
  print(dim(cd[[i]]))
}

colnames(cd[["H"]]) = paste0("H_",colnames(cd[["H"]]))
colnames(cd[["C"]]) = paste0("C_",colnames(cd[["C"]]))
colnames(cd[["B"]]) = paste0("B_",colnames(cd[["B"]]))
colnames(cd[["M"]]) = paste0("M_",colnames(cd[["M"]]))


#cd <- cbind(cd[["H"]],cd[["C"]],cd[["B"]],cd[["M"]])
#dim(cd)

#species <- unlist(lapply(strsplit(colnames(cd),"_"),function (x) x[1]))
#table(species)

#str(cd)

region.table = read.table(paste0("/uge_mnt/home/khrameeva/single-cell/bams/all_",regions,".cells"),
header=F,sep="\t")

#for (species.selected in c("H","C","B","M","ALL")){
for (species.selected in c("ALL")){
if (species.selected == "H"){
	print(species.selected)
	cd.species = cd[["H"]]
	cd.species = cd.species[,colnames(cd.species) %in% region.table[,1]]
}else if (species.selected == "C"){
	print(species.selected)
	cd.species = cd[["C"]]
	cd.species = cd.species[,colnames(cd.species) %in% region.table[,1]]
}else if (species.selected == "B"){
	print(species.selected)
	cd.species = cd[["B"]]
	cd.species = cd.species[,colnames(cd.species) %in% region.table[,1]]
}else if (species.selected == "M"){
	print(species.selected)
	cd.species = cd[["M"]]
	cd.species = cd.species[,colnames(cd.species) %in% region.table[,1]]
}else if (species.selected == "ALL"){
	print(species.selected)
	cd.species = cbind(cd[["H"]],cd[["C"]],cd[["B"]],cd[["M"]])
	cd.species = cd.species[,colnames(cd.species) %in% region.table[,1]]
}

pbmc <- CreateSeuratObject(raw.data = cd.species, min.cells = round(dim(cd.species)[2]*0.001,0), min.genes = 0, project = "10X_brain")
rownames(orth) = orth[,1]
orth1 = orth[rownames(x = pbmc@data),]

mito.genes <- names(grep(pattern = "^hg38____MT-", x = orth1[,5], value = TRUE))
percent.mito <- Matrix::colSums(pbmc@raw.data[mito.genes, ])/Matrix::colSums(pbmc@raw.data)
pbmc <- AddMetaData(object = pbmc, metadata = percent.mito, col.name = "percent.mito")

pdf(paste0("qc.stats.",regions,".",species.selected,".pdf"),width=9,height=5)
VlnPlot(object = pbmc, features.plot = c("nGene", "nUMI", "percent.mito"), nCol = 3)
dev.off()

pbmc <- FilterCells(object = pbmc, subset.names = c("nGene", "percent.mito"), low.thresholds = c(50, -Inf), high.thresholds = c(5000, 0.05))
pbmc <- NormalizeData(object = pbmc, normalization.method = "LogNormalize", scale.factor = 10000)

pbmc <- FindVariableGenes(object = pbmc, mean.function = ExpMean, dispersion.function = LogVMR, 
    x.low.cutoff = 0.0125, x.high.cutoff = 3, y.cutoff = 0.5)
length(x = pbmc@var.genes)  

pbmc <- ScaleData(object = pbmc, vars.to.regress = c("nUMI", "percent.mito"))

pcs.stores = 20
if(species.selected == "ALL"){
pcs.stores = 40
}

#pcs.stores = 30


pbmc <- RunPCA(object = pbmc, pc.genes = pbmc@var.genes, do.print = TRUE, pcs.compute = pcs.stores, pcs.print = 1:5, 
    genes.print = 5)
pbmc <- ProjectPCA(object = pbmc, pcs.store = pcs.stores, do.print = FALSE)
  
pbmc <- JackStraw(object = pbmc, num.pc = pcs.stores, num.replicate = 100, display.progress = FALSE)
pdf(paste0("jackstraw.",regions,".",species.selected,".pdf"),width=12,height=20)
JackStrawPlot(object = pbmc, PCs = 1:pcs.stores)
dev.off()

jack.object = JackStrawPlot(object = pbmc, PCs = 1:pcs.stores)
p.vals <- as.numeric(jack.object@dr$pca@jackstraw@overall.p.values[,2])
dims.selected = (min(which(p.vals > 10^(-3)))-1)

if (dims.selected < 2){
dims.selected = 2
}else if (dims.selected == Inf){
dims.selected = pcs.stores
}

#dims.selected = 20

pbmc <- FindClusters(object = pbmc, reduction.type = "pca", dims.use = 1:dims.selected, resolution = 0.6, print.output = 0, save.SNN = TRUE)
PrintFindClustersParams(object = pbmc)

pdf(paste0("tsne.",regions,".",species.selected,".different.perplex.20.pdf"),width=8,height=8)
pbmc <- RunTSNE(object = pbmc, dims.use = 1:dims.selected, do.fast = TRUE, perplexity=10,check_duplicates = FALSE)
TSNEPlot(object = pbmc)
pbmc <- RunTSNE(object = pbmc, dims.use = 1:dims.selected, do.fast = TRUE, perplexity=30,check_duplicates = FALSE)
TSNEPlot(object = pbmc)
pbmc <- RunTSNE(object = pbmc, dims.use = 1:dims.selected, do.fast = TRUE, perplexity=50,check_duplicates = FALSE)
TSNEPlot(object = pbmc)
pbmc <- RunTSNE(object = pbmc, dims.use = 1:dims.selected, do.fast = TRUE, perplexity=100,check_duplicates = FALSE)
TSNEPlot(object = pbmc)
pbmc <- RunTSNE(object = pbmc, dims.use = 1:dims.selected, do.fast = TRUE, perplexity=250,check_duplicates = FALSE)
TSNEPlot(object = pbmc)
#pbmc <- RunTSNE(object = pbmc, dims.use = 1:30, do.fast = TRUE, perplexity=1000,check_duplicates = FALSE)
#TSNEPlot(object = pbmc)
#pbmc <- RunTSNE(object = pbmc, dims.use = 1:30, do.fast = TRUE, perplexity=10000,check_duplicates = FALSE)
#TSNEPlot(object = pbmc)
dev.off()

pbmc.markers <- FindAllMarkers(object = pbmc, only.pos = TRUE, 
test.use = "wilcox", min.pct = 0.1, return.thresh = 0.1)

top10 <- pbmc.markers %>% group_by(cluster) %>% top_n(10, avg_logFC)
top100 <- pbmc.markers %>% group_by(cluster) %>% top_n(100, avg_logFC)
write.table(top100,paste0("top100.",regions,".",species.selected,".txt"),row.names=F,col.names=T,quote=F,sep="\t")

png(paste0("heatmap.",regions,".",species.selected,".png"),res=600,pointsize=5.75,width=4800*1.5,height=4800)
plot1 <- DoHeatmap(object = pbmc, genes.use = top10$gene, slim.col.label = TRUE, remove.key = TRUE)
print(plot1)
dev.off()

saveRDS(pbmc, file = paste0("data.",regions,".",species.selected,".rds"))

}
}

dir.3 <-paste0("/uge_mnt/home/ilyak/SCrnaseq/brainmap/species.regions/markers_",regions,"_",species.selected)
dir.create(dir.3)
setwd(dir.3)

library(Seurat)
library(dplyr)

regions = "cer"
pcs.stores = 40

pbmc = readRDS(paste0("../data.",regions,".ALL.rds"))

jack.object = JackStrawPlot(object = pbmc, PCs = 1:pcs.stores)
p.vals <- as.numeric(jack.object@dr$pca@jackstraw@overall.p.values[,2])
dims.selected = (min(which(p.vals > 0.001))-1)

pbmc <- FindClusters(object = pbmc, reduction.type = "pca", dims.use = 1:dims.selected, resolution = 0.6, print.output = 0, save.SNN = TRUE)
PrintFindClustersParams(object = pbmc)

pbmc <- RunTSNE(object = pbmc, dims.use = 1:dims.selected, do.fast = TRUE, perplexity=10,check_duplicates = FALSE)

pbmc2 = pbmc
replicate.info <- data.frame(replicate = unlist(strsplit(names(pbmc@ident),"_"))[seq(1,2*length(names(pbmc@ident)),2)], 
row.names = pbmc2@cell.names)
pbmc2 <- AddMetaData(object = pbmc2, metadata = replicate.info)
pbmc2 <- SetAllIdent(object = pbmc2, id = "replicate")

#pdf(paste0("tsne.",regions,".species.cols.v3.pdf"),width=8,height=8)
#TSNEPlot(object = pbmc2,pt.size=0.5, colors.use=c("#800080","blue","red","forestgreen"))
#dev.off()

png(paste0("tsne.",regions,".species.cols.v01.png"),res=600,pointsize=5.75,width=4800,height=4800)
TSNEPlot(object = pbmc2,pt.size=0.1, colors.use=c("#800080","blue","red","forestgreen"))
dev.off()

#pbmc_acc = pbmc
#pbmc_cn = pbmc
#pbmc_cer = pbmc

pbmc3 = pbmc
numbers.v2 = as.numeric(unlist(strsplit(names(pbmc@ident),"-"))[seq(2,2*length(names(pbmc@ident)),2)])
selected.regions = c()
for (i in 1:length(numbers.v2)){
	if (numbers.v2[i] %in% 1:6){
		selected.regions = c(selected.regions, "Cer")
	}else if(numbers.v2[i] %in% 7:12){
		selected.regions = c(selected.regions, "Cn")
	}else if(numbers.v2[i] %in% 13:17){
		selected.regions = c(selected.regions, "Acc")
	}
}

replicate.info <- data.frame(replicate = selected.regions, 
row.names = pbmc3@cell.names)
pbmc3 <- AddMetaData(object = pbmc3, metadata = replicate.info)
pbmc3 <- SetAllIdent(object = pbmc3, id = "replicate")
pdf("tsne.all.brain.region.v3.pdf",width=8,height=8)
TSNEPlot(object = pbmc3)
dev.off()

png(paste0("tsne.",regions,".region.cols.v01.png"),res=600,pointsize=5.75,width=4800,height=4800)
TSNEPlot(object = pbmc3,pt.size=0.1, colors.use=c("#FF9801","#26A59A","#1665C0"))
dev.off()

for (i in neuronal.type){
selected.genes = as.character(feature.genes2[feature.genes2[,4]==i,3])
sc.param = 300
if (length(selected.genes)<4){
	w = 4
	h = 4
}else{
	w = 16
	h = 16
}                                               
png(paste0(i,"_all.brain.tsne.png"),width=w*sc.param,height=h*sc.param)                               
FeaturePlot(object = pbmc, features.plot = selected.genes,
 cols.use = c(rgb(0.99,0.99,0.99,0.0001), "blue"), pt.size = 2, reduction.use = "tsne")
dev.off()
}


for (i in neuronal.type){
selected.genes = unique(as.character(feature.genes2[feature.genes2[,4]==i,3]))
sc.param = 30
h = 16
w = 4 + 1 * length(selected.genes)                                       
png(paste0(i,"_all.brain.doplots.png"),width=w*sc.param,height=h*sc.param)                               
DotPlot(object = pbmc, genes.plot = selected.genes, 
plot.legend = TRUE) + theme(axis.text.x = element_text(angle = 90, hjust = 1),
panel.grid.minor = element_blank(),plot.title = element_text(hjust = 0.5),text = element_text(face="bold"))
dev.off()
}

customize_Seurat_FeaturePlot <- function(p, alpha.use = 1, gradient.use = c("yellow", "red"), expression.threshold = 0, is.log1p.transformed = F) {
  
  #### Main function ####
  main_function <- function(p = p, alpha.use = alpha.use, gradient.use = gradient.use, expression.threshold = expression.threshold, is.log1p.transformed = is.log1p.transformed) {
    
    # Order data by gene expresion level
    p$data <- p$data[order(p$data$gene),]
    
    # Define lower limit of gene expression level
    if (isTRUE(is.log1p.transformed)) {
      expression.threshold <- expression.threshold
    } else {
      expression.threshold <- log1p(expression.threshold)
    }
    
    # Compute maximum value in gene expression
    max.exp <- max(p$data$gene)
    
    # Fill points using the gene expression levels
    p$layers[[1]]$mapping$fill <- p$layers[[1]]$mapping$colour
    
    # Define transparency of points
    p$layers[[1]]$mapping$alpha <- alpha.use
    
    # Change fill and colour gradient values
    p <- p + scale_colour_gradientn(colours = gradient.use, guide = F, limits = c(expression.threshold, max.exp), na.value = "grey") +
      scale_fill_gradientn(colours = gradient.use, name = expression(atop(Expression, (log))), limits = c(expression.threshold, max.exp), na.value = "grey") +
      scale_alpha_continuous(range = alpha.use, guide = F)
  }
  
  #### Execution of main function ####
  # Apply main function on all features
  p <- lapply(X = p, alpha.use = alpha.use, gradient.use = gradient.use, 
              expression.threshold = expression.threshold, is.log1p.transformed = is.log1p.transformed,
              FUN = main_function)
  
  # Arrange all plots using cowplot
  # Adapted from Seurat
  # https://github.com/satijalab/seurat/blob/master/R/plotting.R#L1100
  # ncol argument adapted from Josh O'Brien
  # https://stackoverflow.com/questions/10706753/how-do-i-arrange-a-variable-list-of-plots-using-grid-arrange
  print(cowplot::plot_grid(plotlist = p, ncol = ceiling(sqrt(length(p)))))
}


jack.object = JackStrawPlot(object = pbmc, PCs = 1:pcs.stores)
p.vals <- as.numeric(jack.object@dr$pca@jackstraw@overall.p.values[,2])
dims.selected = (min(which(p.vals > 0.001))-1)

pbmc <- FindClusters(object = pbmc, reduction.type = "pca", dims.use = 1:dims.selected, resolution = 0.6, print.output = 0, save.SNN = TRUE)
PrintFindClustersParams(object = pbmc)

pbmc <- RunTSNE(object = pbmc, dims.use = 1:dims.selected, do.fast = TRUE, perplexity=10,check_duplicates = FALSE)

feature.genes = read.table("/uge_mnt/home/khrameeva/single-cell/pagoda/ens.txt",header=T,sep="\t")
feature.genes2 = feature.genes[feature.genes[,3] %in% rownames(pbmc@data),]
neuronal.type = names(table(as.character(feature.genes2[,4])))


for (i in neuronal.type){
selected.genes = as.character(feature.genes2[feature.genes2[,4]==i,3])
	for (j in selected.genes){
		png(paste0(i,"_",j,"_",regions,".png"),res=600,pointsize=5.75,width=4800,height=4800)                               
		plot <- FeaturePlot(object = pbmc, features.plot = j, cols.use = c("yellow", "red"), 
                    pt.size = 1, pch.use = 16, no.legend = F, reduction.use = "tsne", do.return = T)
		plot1 <- customize_Seurat_FeaturePlot(p = plot, is.log1p.transformed = F, expression.threshold = 1)
		plot1
		dev.off()
	}
}

for (i in neuronal.type){
selected.genes = as.character(feature.genes2[feature.genes2[,4]==i,3])
sc.param = 300
if (length(selected.genes)<4){
	w = 4
	h = 4
}else{
	w = 16
	h = 16
}                                               
png(paste0(i,"_all.brain.tsne.v4.png"),width=w*sc.param,height=h*sc.param)                               
plot <- FeaturePlot(object = pbmc, features.plot = selected.genes, cols.use = c("yellow", "red"), 
                    pt.size = 2, pch.use = 16, no.legend = F, reduction.use = "tsne", do.return = T)
plot <- lapply(X = plot, function(p) { p$data <- p$data[order(p$data$gene),]; p})
cowplot::plot_grid(plotlist = plot, ncol = ceiling(sqrt(length(plot))))
dev.off()
}

regions = "acc"
pbmc = pbmc_acc

png(paste0("tsne.",regions,".сlusters.png"),res=600,pointsize=5.75,width=4800,height=4800)
TSNEPlot(object = pbmc,pt.size=1)
dev.off()


pbmc.markers <- FindAllMarkers(object = pbmc, only.pos = TRUE, min.pct = 0.25, 
    thresh.use = 0.25)

pbmc.markers %>% group_by(cluster) %>% top_n(2, avg_logFC)
top10 <- pbmc.markers %>% group_by(cluster) %>% top_n(10, avg_logFC)
top20 <- pbmc.markers %>% group_by(cluster) %>% top_n(20, avg_logFC)
write.table(top20,paste0("top20.",regions,".",species.selected,".txt"),row.names=F,col.names=T,quote=F,sep="\t")

png(paste0("heatmap.",regions,".",species.selected,".png"),res=600,pointsize=5.75,width=4800*1.5,height=4800)
DoHeatmap(object = pbmc, genes.use = top10$gene, slim.col.label = TRUE, remove.key = TRUE)
dev.off()


species.selected = "H"

pbmc3 <- FindClusters(
  object = pbmc,
  reduction.type = "pca",
  resolution = c(0.1,0.2,0.3,0.4,0.5,0.6,0.7,0.8,0.9,1.0),
  dims.use = 1:15,
  save.SNN = TRUE
)

pdf(paste0("tsne.",regions,".",species.selected,".different.clustering.pdf"),width=8,height=8)
pbmc3 <- SetAllIdent(object = pbmc3, id = "res.0.1")
pbmc3 <- RunTSNE(object = pbmc3, dims.use = 1:15, do.fast = TRUE, perplexity=10,check_duplicates = FALSE)
TSNEPlot(object = pbmc3)
pbmc3 <- RunTSNE(object = pbmc3, dims.use = 1:15, do.fast = TRUE, perplexity=50,check_duplicates = FALSE)
TSNEPlot(object = pbmc3)
pbmc3 <- SetAllIdent(object = pbmc3, id = "res.0.2")
pbmc3 <- RunTSNE(object = pbmc3, dims.use = 1:15, do.fast = TRUE, perplexity=10,check_duplicates = FALSE)
TSNEPlot(object = pbmc3)
pbmc3 <- RunTSNE(object = pbmc3, dims.use = 1:15, do.fast = TRUE, perplexity=50,check_duplicates = FALSE)
TSNEPlot(object = pbmc3)
pbmc3 <- SetAllIdent(object = pbmc3, id = "res.0.3")
pbmc3 <- RunTSNE(object = pbmc3, dims.use = 1:15, do.fast = TRUE, perplexity=10,check_duplicates = FALSE)
TSNEPlot(object = pbmc3)
pbmc3 <- RunTSNE(object = pbmc3, dims.use = 1:15, do.fast = TRUE, perplexity=50,check_duplicates = FALSE)
TSNEPlot(object = pbmc3)
pbmc3 <- SetAllIdent(object = pbmc3, id = "res.0.4")
pbmc3 <- RunTSNE(object = pbmc3, dims.use = 1:15, do.fast = TRUE, perplexity=10,check_duplicates = FALSE)
TSNEPlot(object = pbmc3)
pbmc3 <- RunTSNE(object = pbmc3, dims.use = 1:15, do.fast = TRUE, perplexity=50,check_duplicates = FALSE)
TSNEPlot(object = pbmc3)
pbmc3 <- SetAllIdent(object = pbmc3, id = "res.0.5")
pbmc3 <- RunTSNE(object = pbmc3, dims.use = 1:15, do.fast = TRUE, perplexity=10,check_duplicates = FALSE)
TSNEPlot(object = pbmc3)
pbmc3 <- RunTSNE(object = pbmc3, dims.use = 1:15, do.fast = TRUE, perplexity=50,check_duplicates = FALSE)
TSNEPlot(object = pbmc3)
pbmc3 <- SetAllIdent(object = pbmc3, id = "res.0.6")
pbmc3 <- RunTSNE(object = pbmc3, dims.use = 1:15, do.fast = TRUE, perplexity=10,check_duplicates = FALSE)
TSNEPlot(object = pbmc3)
pbmc3 <- RunTSNE(object = pbmc3, dims.use = 1:15, do.fast = TRUE, perplexity=50,check_duplicates = FALSE)
TSNEPlot(object = pbmc3)
pbmc3 <- SetAllIdent(object = pbmc3, id = "res.0.7")
pbmc3 <- RunTSNE(object = pbmc3, dims.use = 1:15, do.fast = TRUE, perplexity=10,check_duplicates = FALSE)
TSNEPlot(object = pbmc3)
pbmc3 <- RunTSNE(object = pbmc3, dims.use = 1:15, do.fast = TRUE, perplexity=50,check_duplicates = FALSE)
TSNEPlot(object = pbmc3)
pbmc3 <- SetAllIdent(object = pbmc3, id = "res.0.8")
pbmc3 <- RunTSNE(object = pbmc3, dims.use = 1:15, do.fast = TRUE, perplexity=10,check_duplicates = FALSE)
TSNEPlot(object = pbmc3)
pbmc3 <- RunTSNE(object = pbmc3, dims.use = 1:15, do.fast = TRUE, perplexity=50,check_duplicates = FALSE)
TSNEPlot(object = pbmc3)
pbmc3 <- SetAllIdent(object = pbmc3, id = "res.0.9")
pbmc3 <- RunTSNE(object = pbmc3, dims.use = 1:15, do.fast = TRUE, perplexity=10,check_duplicates = FALSE)
TSNEPlot(object = pbmc3)
pbmc3 <- RunTSNE(object = pbmc3, dims.use = 1:15, do.fast = TRUE, perplexity=50,check_duplicates = FALSE)
TSNEPlot(object = pbmc3)
pbmc3 <- SetAllIdent(object = pbmc3, id = "res.1")
pbmc3 <- RunTSNE(object = pbmc3, dims.use = 1:15, do.fast = TRUE, perplexity=10,check_duplicates = FALSE)
TSNEPlot(object = pbmc3)
pbmc3 <- RunTSNE(object = pbmc3, dims.use = 1:15, do.fast = TRUE, perplexity=50,check_duplicates = FALSE)
TSNEPlot(object = pbmc3)
dev.off()


for (res1 in c(0.1,0.2,0.3,0.4,0.5,0.6,0.7,0.8,0.9,1))
{
res1 = 0.1
resolution = paste0("res.",res1)
#if (res1 == 1){
#	resolution = "res.1"
#}
pbmc3 <- SetAllIdent(object = pbmc3, id = resolution)

pbmc.markers <- FindAllMarkers(object = pbmc3, only.pos = TRUE, min.pct = 0.25, 
    thresh.use = 0.25)

pbmc.markers %>% group_by(cluster) %>% top_n(2, avg_logFC)
top10 <- pbmc.markers %>% group_by(cluster) %>% top_n(10, avg_logFC)
top20 <- pbmc.markers %>% group_by(cluster) %>% top_n(20, avg_logFC)
write.table(top20,paste0("top20.",regions,".",species.selected,".",resolution,".txt"),row.names=F,col.names=T,quote=F,sep="\t")

png(paste0("heatmap.",regions,".",species.selected,".",resolution,".png"),res=600,pointsize=5.75,width=4800*1.5,height=4800)
DoHeatmap(object = pbmc3, genes.use = top10$gene, slim.col.label = TRUE, remove.key = TRUE)
dev.off()
}


for (regions in c("acc","cn","cer","brainmap")){
	for (species.selected in c("H","ALL")){
#for (regions in c("brainmap")){
#	for (species.selected in c("ALL")){


		dir.3 <-paste0("/uge_mnt/home/ilyak/SCrnaseq/brainmap/species.regions/markers_",regions,"_",species.selected)
		dir.create(dir.3)
		setwd(dir.3)

		library(Seurat)
		library(dplyr)

		if (species.selected != "ALL"){
			pcs.stores = 20
		}else{
			pcs.stores = 40
		}
		
		print(regions)
		print(species.selected)

		pbmc = readRDS(paste0("../data.filtered.v2/data.",regions,".",species.selected,".rds"))

		jack.object = JackStrawPlot(object = pbmc, PCs = 1:pcs.stores)
		p.vals <- as.numeric(jack.object@dr$pca@jackstraw@overall.p.values[,2])
		dims.selected = (min(which(p.vals > 0.001))-1)

		pbmc <- FindClusters(object = pbmc, reduction.type = "pca", dims.use = 1:dims.selected, resolution = 0.6, print.output = 0, save.SNN = TRUE)
		PrintFindClustersParams(object = pbmc)

		pbmc <- RunTSNE(object = pbmc, dims.use = 1:dims.selected, do.fast = TRUE, perplexity=10,check_duplicates = FALSE)

		feature.genes = read.table("/uge_mnt/home/khrameeva/single-cell/pagoda/ens.txt",header=T,sep="\t")
		feature.genes2 = feature.genes[feature.genes[,3] %in% rownames(pbmc@data),]
		neuronal.type = names(table(as.character(feature.genes2[,4])))


		for (i in neuronal.type){
			selected.genes = as.character(feature.genes2[feature.genes2[,4]==i,3])
			for (j in selected.genes){
				png(paste0(i,"_",j,"_",regions,".png"),res=600,pointsize=5.75,width=4800,height=4800)                               
					plot <- FeaturePlot(object = pbmc, features.plot = j, cols.use = c("yellow", "red"), 
                    	pt.size = 1, pch.use = 16, no.legend = F, reduction.use = "tsne", do.return = T)
				plot1 <- customize_Seurat_FeaturePlot(p = plot, is.log1p.transformed = F, expression.threshold = 1)
				plot1
				dev.off()
			}
		}


	}
}


for (regions in c("acc","cn","cer","brainmap")){

		print(regions)

		pbmc = readRDS(paste0("data.",regions,".ALL.rds"))
		pcs.stores = 40
		
		jack.object = JackStrawPlot(object = pbmc, PCs = 1:pcs.stores)
		p.vals <- as.numeric(jack.object@dr$pca@jackstraw@overall.p.values[,2])
		dims.selected = (min(which(p.vals > 0.001))-1)

		pbmc <- FindClusters(object = pbmc, reduction.type = "pca", dims.use = 1:dims.selected, resolution = 0.6, print.output = 0, save.SNN = TRUE)
		PrintFindClustersParams(object = pbmc)

		pbmc <- RunTSNE(object = pbmc, dims.use = 1:dims.selected, do.fast = TRUE, perplexity=10,check_duplicates = FALSE)


		pbmc2 = pbmc
		replicate.info <- data.frame(replicate = unlist(strsplit(names(pbmc@ident),"_"))[seq(1,2*length(names(pbmc@ident)),2)], 
		row.names = pbmc2@cell.names)
		pbmc2 <- AddMetaData(object = pbmc2, metadata = replicate.info)
		pbmc2 <- SetAllIdent(object = pbmc2, id = "replicate")

		png(paste0("tsne.",regions,".species.cols.v01.png"),res=600,pointsize=5.75,width=4800,height=4800)
		TSNEPlot(object = pbmc2,pt.size=0.1, colors.use=c("#800080","blue","red","forestgreen"))
		dev.off()

		if (regions == "brainmap"){
			pbmc3 = pbmc
			numbers.v2 = as.numeric(unlist(strsplit(names(pbmc@ident),"-"))[seq(2,2*length(names(pbmc@ident)),2)])
			selected.regions = c()
			for (i in 1:length(numbers.v2)){
				if (numbers.v2[i] %in% 1:6){
					selected.regions = c(selected.regions, "cer")
				}else if(numbers.v2[i] %in% 7:12){
					selected.regions = c(selected.regions, "Cn")
				}else if(numbers.v2[i] %in% 13:17){
					selected.regions = c(selected.regions, "Acc")
				}
			}
			
			replicate.info <- data.frame(replicate = selected.regions, 
			row.names = pbmc3@cell.names)
			pbmc3 <- AddMetaData(object = pbmc3, metadata = replicate.info)
			pbmc3 <- SetAllIdent(object = pbmc3, id = "replicate")

			png(paste0("tsne.",regions,".region.cols.v01.png"),res=600,pointsize=5.75,width=4800,height=4800)
			TSNEPlot(object = pbmc3,pt.size=0.1, colors.use=c("#FF9801","#26A59A","#1665C0"))
			dev.off()
		}

}
