library(Seurat)

##Seurat v2.3 plotting of high number os cells
customize_Seurat_FeaturePlot <- function(p, alpha.use = 1, gradient.use = c("yellow", "red"), expression.threshold = 0, is.log1p.transformed = F) {

 #### Main function ####
 main_function <- function(p = p, alpha.use = alpha.use, gradient.use = gradient.use, expression.threshold = expression.threshold, is.log1p.transformed = is.log1p.transformed) {

   print(p$data[[3]])
   # Order data by gene expresion level
   p$data <- p$data[order(p$data[[3]]),]

   # Define lower limit of gene expression level
   if (isTRUE(is.log1p.transformed)) {
     expression.threshold <- expression.threshold
   } else {
     expression.threshold <- log1p(expression.threshold)
   }

   # Compute maximum value in gene expression
   max.exp <- max(p$data[[3]])

   # Fill points using the gene expression levels
   p$layers[[1]]$mapping$fill <- p$layers[[1]]$mapping$colour

   # Define transparency of points
   p$layers[[1]]$mapping$alpha <- alpha.use

   # Change fill and colour gradient values
   p <- p + scale_colour_gradientn(colours = gradient.use, guide = F, limits = c(expression.threshold, max.exp), na.value = "grey") +
     scale_fill_gradientn(colours = gradient.use, name = expression(atop(Expression, (log))), limits = c(expression.threshold, max.exp), na.value = "grey") +
     scale_alpha_continuous(range = alpha.use, guide = F)
 }

 #### Execution of main function ####
 # Apply main function on all features
 p <- lapply(X = p, alpha.use = alpha.use, gradient.use = gradient.use,
             expression.threshold = expression.threshold, is.log1p.transformed = is.log1p.transformed,
             FUN = main_function)

 # Arrange all plots using cowplot
 print(cowplot::plot_grid(plotlist = p, ncol = ceiling(sqrt(length(p)))))
}


##Selecting features
library(pastecs)
library(pracma)

avg_array = function(kl)
{
  apply_whittaker = function(kl)
  {
    kl_new = whittaker(kl, lambda = 3, d = 2)
    names(kl_new) = names(kl)
    kl = kl_new
    return(kl)
  }
  
  if(length(kl)>2)
  {
    kl = apply_whittaker(kl)
  }
  
  
  return(kl)
}

get_model2 = function(mtx, step = 0.01)
{
  max_exprs = apply(log2(mtx+1), 1, FUN = function(x) {
  x = quantile(x, seq(0,1,step))
  return(x)
    })
  
  model = apply(max_exprs, 2, FUN = function(x){
    x = suppressWarnings(length(which(turnpoints(density(avg_array(x))$y)$peaks)))
    return(x)
  })
  
  return(model)
}

model1 = get_model2(object_l@assays$RNA@counts)
model = sort(model1, decreasing = F)


n_gene = sort(nexprs(object_l@assays$RNA@counts, byrow = T), decreasing = T)

model = match(names(n_gene), names(model))
names(model) = names(n_gene)

plot(model)


##Clusters
res1 = 0.6
resolution = paste0("res.",res1)
#if (res1 == 1){
#	resolution = "res.1"
#}
pbmc3 <- SetAllIdent(object = pbmc3, id = resolution)

pbmc.markers <- FindAllMarkers(object = pbmc3, only.pos = TRUE, min.pct = 0.25, 
    thresh.use = 0.25)

pbmc.markers %>% group_by(cluster) %>% top_n(2, avg_logFC)
top10 <- pbmc.markers %>% group_by(cluster) %>% top_n(10, avg_logFC)
top20 <- pbmc.markers %>% group_by(cluster) %>% top_n(20, avg_logFC)
write.table(top20,paste0("top20.",regions,".",species.selected,".",resolution,".txt"),row.names=F,col.names=T,quote=F,sep="\t")

png(paste0("heatmap.",regions,".",species.selected,".",resolution,".png"),res=600,pointsize=5.75,width=4800*1.5,height=4800)
DoHeatmap(object = pbmc3, genes.use = top10$gene, slim.col.label = TRUE, remove.key = TRUE)
dev.off()
