all.data.genes = c("Ensenmbl","Symbol","H-C","H-M","C-M")
for (i in list.files("score.matrix.ortho/")){
  	matrix.table = read.table(paste("score.matrix.ortho/",i,sep=""),skip = 1)
  	if (length(which(matrix.table$V1 %in% c("Homo","Pan","Macaca")))==3){
		ens = unlist(strsplit(i,"_|\\."))[1]
		symbol = unlist(strsplit(i,"_|\\."))[2]
  		human = which(matrix.table$V1 %in% "Homo")
  		pan = which(matrix.table$V1 %in% "Pan")
  		macaca = which(matrix.table$V1 %in% "Macaca")
  		d1 = matrix.table[human,pan+1]
  		d2 = matrix.table[human,macaca+1]
  		d3 = matrix.table[pan,macaca+1]
  		if (d2 == d3){
  			d1=0
  		}
  		all.data.genes = rbind(all.data.genes, c(ens,symbol,d1,d2,d3))
  }
}

write.table(all.data.genes,"JS.genes.nt.txt",row.names=F,col.names=F,sep="\t",quote=F)