#library(RColorBrewer)
#library(gplots)
#library(ape)

####OUR PROCESS
mtx <- as.matrix(read.delim("~/Downloads/###Sousa.align.samples/ProtCoding.34regions_mtx.txt",header=T))
genes.our = rownames(mtx)

mtx <- as.matrix(read.delim("~/Downloads/###Sousa.align.samples/ProtCoding.34regions_mtx.txt.bybrain",header=T))
rownames(mtx) = genes.our

brain2 <- unlist(lapply(strsplit(colnames(mtx),"_"),function (x) x[length(x)-1]))
id2 <- unlist(lapply(strsplit(colnames(mtx),"_"),function (x) x[length(x)]))
ms2 <- unlist(lapply(strsplit(colnames(mtx),"_"),function (x) x[length(x)-2]))
species2 <- unlist(lapply(strsplit(brain2,""),function (x) x[1]))

mtx <- mtx[,brain2!="CHA"&species2!="B"]
samples2 <- samples2[brain2!="CHA"&species2!="B"]
species2 <- species2[brain2!="CHA"&species2!="B"]

batches2 <- as.matrix(read.table("~/Downloads/###Sousa.align.samples/batches_34groups_4ctx_newNames.txt",header=F,fill=T,row.names=2,sep="\t"))
regions2 = batches2[colnames(mtx),7]

norm2 = mtx

############SOUSA PROCESS
#gexp.total2 =  read.table("~/Downloads/###Sousa.align.samples/gexp.together.txt",header=T)
#rownames(gexp.total2) = gexp.total2[,1]
#gexp.total2 = gexp.total2[,-1]
#gexp.total3 = log10(gexp.total2 + 1)
#gexp.total4 = apply(gexp.total3,2,as.numeric)
#gexp.total5 = calc_uq(gexp.total4)
#rownames(gexp.total5) = rownames(gexp.total3)


gexp.total5 = read.table("~/Downloads/###Sousa.align.samples/gexp.together.norm.txt",header=T)

cor.matrix = c()

our.human = c()
sousa.human = c()
our.chimp = c()
sousa.chimp = c()
our.mac = c()
sousa.mac = c()

meta.compare = read.table("~/Downloads/###Sousa.align.samples/meta.together.final.txt",sep="\t",header=T)
all.sousa.reg = unique(meta.compare$Region)
all.sousa.reg.one = all.sousa.reg[-c(4,13)]
all.sousa.reg.mult = all.sousa.reg[c(4,13)]

hs.regions = read.table("~/Downloads/###Sousa.align.samples/human-spec_ProtCoding_1.0.pdf.txt",sep="\t",header=T)

for (i in unique(all.sousa.reg.one)){
region.vector = c()

selected.region = i
pdf(paste("~/Downloads/",unlist(strsplit(selected.region," "))[1],".comp.pdf",sep=""),height=16,width=6)
par(mfrow = c(2,1))
meta.1visual = meta.compare[which(meta.compare$Region==selected.region),]
gexp.1visual = gexp.total5[,meta.1visual$ID]

our.pvals = apply(norm2,1,function(x){t.test(x[which(regions2==selected.region & species2=="H")],x[which(regions2==selected.region & species2=="C")])$p.value})
sousa.pvals = apply(gexp.1visual,1,function(x){t.test(x[which(meta.1visual$Species == "Human")],x[which(meta.1visual$Species == "Pan troglodytes")])$p.value})

genes.subset = intersect(names(our.pvals)[our.pvals<0.01],names(sousa.pvals)[sousa.pvals<0.01])
#genes.subset = intersect(rownames(norm2),rownames(gexp.1visual))


humans = rowMeans(gexp.1visual[genes.subset,meta.1visual[which(meta.1visual$Species == "Human"),]$ID]) - rowMeans(gexp.1visual[genes.subset,meta.1visual[which(meta.1visual$Species == "Pan troglodytes"),]$ID])
humans2 = rowMeans(norm2[genes.subset,which(regions2==selected.region & species2=="H")]) - rowMeans(norm2[genes.subset,which(regions2==selected.region & species2 =="C")])

plot(humans2,humans,pch=19,main=paste("Human vs. Other, cor = ",cor(humans2,humans),sep=""))

region.vector = c(region.vector,cor(humans2,humans))
our.human = c(our.human,humans2)
sousa.human = c(sousa.human,humans)

genes.subset = intersect(names(our.pvals)[our.pvals<0.05],names(sousa.pvals)[sousa.pvals<0.05])

chimps = rowMeans(gexp.1visual[genes.subset,meta.1visual[which(meta.1visual$Species == "Human"),]$ID]) - rowMeans(gexp.1visual[genes.subset,meta.1visual[which(meta.1visual$Species == "Pan troglodytes"),]$ID])
chimps2 = rowMeans(norm2[genes.subset,which(regions2==selected.region & species2=="H")]) - rowMeans(norm2[genes.subset,which(regions2==selected.region & species2 =="C")])

plot(chimps2,chimps,pch=19,main=paste("Human vs. Other, cor = ",cor(chimps2,chimps),sep=""))

region.vector = c(region.vector,cor(chimps2,chimps))
our.chimp = c(our.chimp,chimps2)
sousa.chimp = c(sousa.chimp,chimps)

dev.off()

cor.matrix = rbind(cor.matrix,region.vector)

}

for (i in unique(all.sousa.reg.mult)){
region.vector = c()
selected.region = i
selected.region.2 = unlist(strsplit(selected.region,", "))
first.region = unlist(strsplit(selected.region," "))[1]

pdf(paste("~/Downloads/",unlist(strsplit(first.region," "))[1],".comp.pdf",sep=""),height=16,width=6)
meta.1visual = meta.compare[which(meta.compare$Region==selected.region),]
gexp.1visual = gexp.total5[,meta.1visual$ID]

our.pvals = apply(norm2,1,function(x){t.test(x[which(regions2 %in% selected.region.2 & species2=="H")],x[which(regions2 %in% selected.region.2 & species2=="C")])$p.value})
sousa.pvals = apply(gexp.1visual,1,function(x){t.test(x[which(meta.1visual$Species == "Human")],x[which(meta.1visual$Species == "Pan troglodytes")])$p.value})

genes.subset = intersect(names(our.pvals)[our.pvals<0.01],names(sousa.pvals)[sousa.pvals<0.01])
#genes.subset = intersect(rownames(norm2),rownames(gexp.1visual))

humans = rowMeans(gexp.1visual[genes.subset,meta.1visual[which(meta.1visual$Species == "Human"),]$ID]) - rowMeans(gexp.1visual[genes.subset,meta.1visual[which(meta.1visual$Species == "Pan troglodytes"),]$ID])
humans2 = rowMeans(norm2[genes.subset,which(regions2 %in% selected.region.2 & species2=="H")]) - rowMeans(norm2[genes.subset,which(regions2 %in% selected.region.2 & species2 =="C")])

plot(humans2,humans,pch=19,main=paste("Human vs. Other, cor = ",cor(humans2,humans),sep=""))

region.vector = c(region.vector,cor(humans2,humans))
our.human = c(our.human,humans2)
sousa.human = c(sousa.human,humans)

genes.subset = intersect(names(our.pvals)[our.pvals<0.05],names(sousa.pvals)[sousa.pvals<0.05])

chimps = rowMeans(gexp.1visual[genes.subset,meta.1visual[which(meta.1visual$Species == "Human"),]$ID]) - rowMeans(gexp.1visual[genes.subset,meta.1visual[which(meta.1visual$Species == "Pan troglodytes"),]$ID])
chimps2 = rowMeans(norm2[genes.subset,which(regions2 %in% selected.region.2 & species2=="H")]) - rowMeans(norm2[genes.subset,which(regions2 %in% selected.region.2 & species2 =="C")])

plot(chimps2,chimps,pch=19,main=paste("Chimp vs. Other, cor = ",cor(chimps2,chimps),sep=""))
region.vector = c(region.vector,cor(chimps2,chimps))
our.chimp = c(our.chimp,chimps2)
sousa.chimp = c(sousa.chimp,chimps)

dev.off()

cor.matrix = rbind(cor.matrix,region.vector)

}



rownames(cor.matrix) = c("HIP","S1C","STC","V1C","VFC","CBC","AMY","A1C","M1C","ITC","IPC","MD","OFC","DFC","STR","MFC")
colnames(cor.matrix) = c("Human1","Human5")
#colnames(cor.matrix) = c("Human","Chimp","Macaque")

cor.matrix = cor.matrix[c("MFC","OFC","DFC","VFC","M1C","S1C","IPC","A1C","STC","ITC","V1C","HIP","AMY","STR","MD","CBC"),]

#rownames(cor.matrix) = c("HIP","S1C","STC","V1C","VFC","CBC","AMY","A1C","M1C","ITC","IPC","MD","OFC","DFC")
#colnames(cor.matrix) = c("Human","Chimp")

labels <- c("MFC","OFC","DFC","VFC","M1C","S1C","IPC","A1C","STC","ITC","V1C","HIP","AMY","STR","MD","CBC")
plot((cor.matrix[,1]),xaxt="n",xlab="",ylab="Correlation")
axis(side=1, at=1:16, labels=labels)

#pdf("~/Downloads/gexp.2ds.corr.pdf",width=6,height = 6)
#pheatmap(cor.matrix,cluster_rows = F,cluster_cols = F)
#dev.off()

#pdf("~/Downloads/regions.all.togherher.comp.pdf",height=16,width=6)
#par(mfrow = c(3,1))
#plot(our.human,sousa.human,pch=19,main=paste("Human vs. Other, cor = ",cor(our.human,sousa.human),sep=""))
#plot(our.chimp,sousa.chimp,pch=19,main=paste("Chimp vs. Other, cor = ",cor(our.chimp,sousa.chimp),sep=""))
#plot(our.mac,sousa.mac,pch=19,main=paste("Macaca vs. Other, cor = ",cor(our.mac,sousa.mac),sep=""))
#dev.off()