cor.matrix = c()

our.human = c()
sousa.human = c()
our.chimp = c()
sousa.chimp = c()
our.mac = c()
sousa.mac = c()

for (i in unique(meta.compare$Region)[-4]){
region.vector = c()

selected.region = i

gexp.total3 = log10(gexp.total2 + 1)
gexp.total4 = apply(gexp.total3,2,as.numeric)
gexp.total5 = calc_uq(gexp.total4)
rownames(gexp.total5) = rownames(gexp.total3)

meta.compare = read.table("~/Downloads/02.03.compare.ds/meta.together.v3.txt",header=T,sep="\t")

prim.visual = read.table(paste("~/Downloads/02.03.compare.ds/regions.no.bo/",selected.region,".txt",sep=""),header=T,sep="\t")
prim.visual2 = prim.visual[rownames(prim.visual) %in% rownames(gexp.total5),]
meta.1visual = meta.compare[which(meta.compare$Region==selected.region),]
gexp.1visual = gexp.total5[rownames(gexp.total5) %in% rownames(prim.visual2),meta.1visual$ID]

#pdf(paste("~/Downloads/",selected.region,".comp.pdf",sep=""),height=16,width=6)
#par(mfrow = c(3,1))
humans = rowMeans(gexp.1visual[rownames(prim.visual2),meta.1visual[which(meta.1visual$Species == "Human"),]$ID]) - rowMeans(gexp.1visual[rownames(prim.visual2),meta.1visual[which(meta.1visual$Species != "Human"),]$ID])
ids1 = which(prim.visual2$max.log10FC.H != "NA")
plot(prim.visual2$max.log10FC.H[ids1],humans[ids1],pch=19,main=paste("Human vs. Other, cor = ",cor(prim.visual2$max.log10FC.H[ids1],humans[ids1]),sep=""))
region.vector = c(region.vector,cor(prim.visual2$max.log10FC.H[ids1],humans[ids1]))
our.human = c(our.human,prim.visual2$max.log10FC.H[ids1])
sousa.human = c(sousa.human,humans[ids1])

chimps = rowMeans(gexp.1visual[rownames(prim.visual2),meta.1visual[which(meta.1visual$Species == "Pan troglodytes"),]$ID]) - rowMeans(gexp.1visual[rownames(prim.visual2),meta.1visual[which(meta.1visual$Species != "Pan troglodytes"),]$ID])
ids2 = which(prim.visual2$max.log10FC.C != "NA")
plot(prim.visual2$max.log10FC.C[ids2],chimps[ids2],pch=19,main=paste("Chimp vs. Other, cor = ",cor(prim.visual2$max.log10FC.C[ids2],chimps[ids2]),sep=""))
region.vector = c(region.vector,cor(prim.visual2$max.log10FC.C[ids2],chimps[ids2]))
our.chimp = c(our.chimp,prim.visual2$max.log10FC.C[ids2])
sousa.chimp = c(sousa.chimp,chimps[ids2])

macacas = rowMeans(gexp.1visual[rownames(prim.visual2),meta.1visual[which(meta.1visual$Species == "Macaca mulatta"),]$ID]) - rowMeans(gexp.1visual[rownames(prim.visual2),meta.1visual[which(meta.1visual$Species != "Macaca mulatta"),]$ID])
ids3 = which(prim.visual2$max.log10FC.M != "NA")
plot(prim.visual2$max.log10FC.M[ids3],macacas[ids3],pch=19,main=paste("Macaca vs. Other, cor = ",cor(prim.visual2$max.log10FC.M[ids3],macacas[ids3]),sep=""))
region.vector = c(region.vector,cor(prim.visual2$max.log10FC.M[ids3],macacas[ids3]))
our.mac = c(our.mac,prim.visual2$max.log10FC.M[ids3])
sousa.mac = c(sousa.mac,macacas[ids3])

#dev.off()

cor.matrix = rbind(cor.matrix,region.vector)

}

#pdf("~/Downloads/gexp.2ds.corr.pdf",width=6,height = 6)
#pheatmap(cor.matrix,cluster_rows = F,cluster_cols = F)
#dev.off()

pdf("~/Downloads/regions.all.togherher.comp.pdf",height=16,width=6)
par(mfrow = c(3,1))
plot(our.human,sousa.human,pch=19,main=paste("Human vs. Other, cor = ",cor(our.human,sousa.human),sep=""))
plot(our.chimp,sousa.chimp,pch=19,main=paste("Chimp vs. Other, cor = ",cor(our.chimp,sousa.chimp),sep=""))
plot(our.mac,sousa.mac,pch=19,main=paste("Macaca vs. Other, cor = ",cor(our.mac,sousa.mac),sep=""))
dev.off()