#!/bin/bash
# Program:
# 	This program ...
# History:
#   2019/01/04 Chou lab First release
# Dataset:
# 	RBSfepb Rep1

##########################################
if [ 1 == 1 ]; then # comment out (switch)
	for i in {1..8}
	do
		awk 'NR%4==2' "RBSfepb_Rep1_Rank"$i".fastq" > "R"$i".txt"
	done
fi # comment out

##########################################
if [ 1 == 1 ]; then # comment out (switch)
	array=( 0 0 2180461 0 0 0 0 0 0) # ReSeq sample size
	for i in 2 # ReSeq
	do
		awk 'NR%4==2' "RBSfepb_Rep1_Rank"$i"_ReSeq.fastq" > "R"$i"_ReSeq.txt"
		gshuf -n ${array[$i]} "R"$i"_ReSeq.txt" >> "R"$i".txt"
		rm "R"$i"_ReSeq.txt"
	done
fi # comment out

##########################################
for i in {1..8}
do
	grep -o "GAACAGTTCCTCACCTTTGGACATAAATCA[ATCG][ATCG][ATCG][ATCG][ATCG][ATCG][ATCG][ATCG][ATCG]TATTAATA" "R"$i".txt" > "R"$i"_match.txt"
done
python ReadCountTable_RBSfepb_Rep1.py
rm *_match.txt*
rm *_SD.txt*

##########################################
for i in {1..8}
do
	grep -o "GAACAGTTCCTCACCTTTGGACATTCTTA[ATCG][ATCG][ATCG][ATCG][ATCG][ATCG][ATCG][ATCG][ATCG]AGGTTCTAG" "R"$i".txt" > "R"$i"_match.txt"
done
python ReadCountTable_RBSarti_Rep1.py
rm *_match.txt*
rm *_SD.txt*
