#!/bin/bash
# Program:
# 	This program ...
# History:
#   2019/01/04 Chou lab First release
# Dataset:
# 	RBSdmsc Rep1

##########################################
if [ 1 == 1 ]; then # comment out (switch)
	for i in {1..8}
	do
		awk 'NR%4==2' "RBSdmsc_Rep1_Rank"$i".fastq" > "R"$i".txt"
	done
fi # comment out

##########################################
if [ 1 == 1 ]; then # comment out (switch)
	array=( 0 0 15437220 0 0 4833 0 0 0) # ReSeq size
	for i in 2 5 # ReSeq
	do
		awk 'NR%4==2' "RBSdmsc_Rep1_Rank"$i"_ReSeq.fastq" > "R"$i"_ReSeq.txt"
		gshuf -n ${array[$i]} "R"$i"_ReSeq.txt" >> "R"$i".txt"
		rm "R"$i"_ReSeq.txt"
		#wc -l "R"$i".txt"
	done
fi # comment out

##########################################
if [ 1 == 1 ]; then # comment out (switch)
	array=( 0 15444523 0 0 0 0 0 0 0) # Sampling size
	for i in 1 # Sampling
	do
		gshuf -n ${array[$i]} "R"$i".txt" > "R"$i"_sampling.txt"
		rm "R"$i".txt"
		mv "R"$i"_sampling.txt" "R"$i".txt"
		#wc -l "R"$i".txt"
	done
fi # comment out

##########################################
if [ 1 == 1 ]; then # comment out (switch)
	for i in {1..8}
	do
		grep -o "GAACAGTTCCTCACCTTTGGACATCTCA[ATCG][ATCG][ATCG][ATCG][ATCG][ATCG][ATCG][ATCG][ATCG]CGGGTTTGCC" "R"$i".txt" > "R"$i"_match.txt"
	done
fi # comment out
python ReadCountTable_RBSdmsc_Rep1.py
rm *_match.txt*
rm *_SD.txt*

##########################################
for i in {1..8}
do
	grep -o "GAACAGTTCCTCACCTTTGGACATTCTTA[ATCG][ATCG][ATCG][ATCG][ATCG][ATCG][ATCG][ATCG][ATCG]AGGTTCTAG" "R"$i".txt" > "R"$i"_match.txt"
done
python ReadCountTable_RBSarti_Rep1.py
rm *_match.txt*
rm *_SD.txt*
