### ====
ViennaCompare <- function(filename, xlim=c(0, 3.2), ylim=c(0, 1.5), n_bin=20, cex=2){
  df <- read.table(file=paste0("FigS7B - ", filename, '_plot.csv'), header=T, sep=",")
  
  x <- df$x
  y <- df$y
  
  print(paste0('min of x = ', min(x, na.rm=T)))
  print(paste0('max of x = ', max(x, na.rm=T)))
  print(paste0('min of y = ', min(y, na.rm=T)))
  print(paste0('max of y = ', max(y, na.rm=T)))
  
  BoxDF <- data.frame(matrix(data=NA, nrow=n_bin, ncol=6))
  colnames(BoxDF) <- c("XMean", "YMean", "YSD", "YQ1", "YMedian", "YQ3")
  BinList <- seq(xlim[1], xlim[2], (xlim[2]-xlim[1])/n_bin)
  for(i in 1:n_bin){
    index <- which(BinList[i]<x & x<BinList[i+1])
    BoxDF$XMean[i] <- mean(x[index], na.rm=T)
    BoxDF$YMean[i] <- mean(y[index], na.rm=T)
    BoxDF$YSD[i] <- sd(y[index], na.rm=T)
    BoxDF$YQ1[i] <- as.numeric(quantile(y[index], 0.25, type=2, na.rm=T))
    BoxDF$YMedian[i] <- as.numeric(quantile(y[index], 0.5, type=2, na.rm=T))
    BoxDF$YQ3[i] <- as.numeric(quantile(y[index], 0.75, type=2, na.rm=T))
  }
  
  pearson_r <- round(cor.test(x, y, method="pearson", exact=FALSE)$estimate, 3)
  spearman_r <- round(cor.test(x, y, method="spearman", exact=FALSE)$estimate, 3)
  print(pearson_r)
  print(spearman_r)
  
  f = paste0("FigS7B - ", filename, ".tiff")
  tiff(filename=f, width=480, height=380, units="px")
  
  plot(x, y, pch=".", xlab="", ylab="", xlim=xlim, ylim=ylim, axes=FALSE, xaxs="i", yaxs="i", col="gray64", cex=cex)
  axis(side=1, at=seq(xlim[1], xlim[2], (xlim[2]-xlim[1])/4), cex.axis=1.5)
  axis(side=2, at=seq(ylim[1], ylim[2], (ylim[2]-ylim[1])/3), cex.axis=1.5)
  box()
  arrows(x0=BoxDF$XMean, y0=BoxDF$YQ1, x1=BoxDF$XMean, y1=BoxDF$YQ3, lwd=9, angle=90, code=0, col="green") # Q1-Q3
  points(x=BoxDF$XMean, y=BoxDF$YMedian, pch=20, col="blue", cex=2.5) # Median
  points(x=BoxDF$XMean, y=BoxDF$YMean, pch=20, col="red", cex=2.5) # Mean
  
  dev.off()
}

### ====
#ViennaCompare("RNAfold_fepB_fepB")
#ViennaCompare("RNAfold_arti_arti")
#ViennaCompare("RNAfold_dmsC_dmsC")
ViennaCompare("dmsc")
ViennaCompare("arti")
ViennaCompare("fepb")














