import numpy as np
import pandas as pd
import matplotlib.pyplot as plt
from util import *

import os
dirname = os.path.dirname(os.path.abspath(__file__))

def main(library):
    df = readDF(library)
    cv = Coefficient_of_Variation(df)

    # print(cv)
    pd.DataFrame({'x':df.LogMean, 'y':cv}).to_csv(dirname+'/FigS7B - '+library+'_plot.csv', index=False)

    # plt.figure()
    # plt.scatter(df.LogMean, cv, s=1, c='gray')
    # GroupPlot(df.LogMean, cv)
    # plt.savefig(library+'_mean of CV='+str(round(np.nanmean(cv), 4))+'.png')

main('fepb')
main('arti')
main('dmsc')


