import numpy as np
import pandas as pd
import matplotlib.pyplot as plt 
from util import *

### figure setting ###
plt.figure(figsize=(24,18))

labelsize = 20
length = 6
color = 'k'
ymax = 3.2
yticks = 5
s = 3 #5
capsize = 6
markersize = 20

ax1 = plt.subplot(3,4,1)
ax1.tick_params(axis='both', which='major', labelsize=labelsize, length=length)
ax2 = plt.subplot(3,4,2, sharex=ax1, sharey=ax1)
ax2.tick_params(axis='both', which='major', labelsize=labelsize, length=length)
ax3 = plt.subplot(3,4,3, sharex=ax1, sharey=ax1)
ax3.tick_params(axis='both', which='major', labelsize=labelsize, length=length)
ax4 = plt.subplot(3,4,4, sharex=ax1, sharey=ax1)
ax4.tick_params(axis='both', which='major', labelsize=labelsize, length=length)
ax5 = plt.subplot(3,4,5, sharex=ax1, sharey=ax1)
ax5.tick_params(axis='both', which='major', labelsize=labelsize, length=length)
ax6 = plt.subplot(3,4,6, sharex=ax1, sharey=ax1)
ax6.tick_params(axis='both', which='major', labelsize=labelsize, length=length)
ax7 = plt.subplot(3,4,7, sharex=ax1, sharey=ax1)
ax7.tick_params(axis='both', which='major', labelsize=labelsize, length=length)
ax8 = plt.subplot(3,4,8, sharex=ax1, sharey=ax1)
ax8.tick_params(axis='both', which='major', labelsize=labelsize, length=length)
ax9 = plt.subplot(3,4,9, sharex=ax1, sharey=ax1)
ax9.tick_params(axis='both', which='major', labelsize=labelsize, length=length)
ax10 = plt.subplot(3,4,10, sharex=ax1, sharey=ax1)
ax10.tick_params(axis='both', which='major', labelsize=labelsize, length=length)
ax11 = plt.subplot(3,4,11, sharex=ax1, sharey=ax1)
ax11.tick_params(axis='both', which='major', labelsize=labelsize, length=length)
ax12 = plt.subplot(3,4,12, sharex=ax1, sharey=ax1)
ax12.tick_params(axis='both', which='major', labelsize=labelsize, length=length)


### fepb ###
mean = np.zeros((4,10))
std = np.zeros((4,10))
df = readDF('fepb')
vec_A = np.array(list(map(lambda x: x.count('A'), df['SeqID'])))
vec_U = np.array(list(map(lambda x: x.count('U'), df['SeqID'])))
vec_C = np.array(list(map(lambda x: x.count('C'), df['SeqID'])))
vec_G = np.array(list(map(lambda x: x.count('G'), df['SeqID'])))

for i in range(10):
    A = df['LogMean'][vec_A == i] 
    U = df['LogMean'][vec_U == i]
    C = df['LogMean'][vec_C == i]
    G = df['LogMean'][vec_G == i]
    mean[0][i] = np.nanmean(A)
    std[0][i] = np.nanstd(A)
    mean[1][i] = np.nanmean(U)
    std[1][i] = np.nanstd(U)
    mean[2][i] = np.nanmean(C)
    std[2][i] = np.nanstd(C)
    mean[3][i] = np.nanmean(G)
    std[3][i] = np.nanstd(G)

    x = i -0.5 + 0.8*np.random.rand(len(A))
    ax1.scatter(x, A, color = color, s = s)
    # add errorbar
    a = np.nanstd(A)
    #print(a,b)
    if not (i == 9):
        ax1.errorbar([i],[mean[0][i]], yerr=[[a],[a]],fmt='r.',markersize = markersize,ecolor='red',elinewidth = 3, capsize =  capsize, capthick = 2)

    x = i -0.5 + 0.8*np.random.rand(len(U))
    ax2.scatter(x, U, color = color, s = s)
    # add errorbar
    a = np.nanstd(U)
    #print(a,b)
    if not (i == 9):
        ax2.errorbar([i],[mean[1][i]], yerr=[[a],[a]],fmt='r.',markersize = markersize, ecolor='red',elinewidth = 3, capsize =  capsize, capthick = 2)        

    x = i -0.5 + 0.8*np.random.rand(len(C))
    ax3.scatter(x, C, color = color, s = s)
    # add errorbar
    a = np.nanstd(C)
    #print(a,b)
    if not (i == 9):
        ax3.errorbar([i],[mean[2][i]], yerr=[[a],[a]],fmt='r.',markersize = markersize,ecolor='red',elinewidth = 3, capsize =  capsize, capthick = 2)        


    x = i-0.5 + 0.8*np.random.rand(len(G))
    ax4.scatter(x, G, color = color, s = s)
    # add errorbar
    a = np.nanstd(G)
    #print(a,b)
    if not (i == 9):
        ax4.errorbar([i],[mean[3][i]], yerr=[[a],[a]],fmt='r.',markersize = markersize,ecolor='red',elinewidth = 3, capsize =  capsize, capthick = 2)

### arti ###
mean = np.zeros((4,10))
std = np.zeros((4,10))
df = readDF('arti')
vec_A = np.array(list(map(lambda x: x.count('A'), df['SeqID'])))
vec_U = np.array(list(map(lambda x: x.count('U'), df['SeqID'])))
vec_C = np.array(list(map(lambda x: x.count('C'), df['SeqID'])))
vec_G = np.array(list(map(lambda x: x.count('G'), df['SeqID'])))

for i in range(10):
    A = df['LogMean'][vec_A == i] 
    U = df['LogMean'][vec_U == i]
    C = df['LogMean'][vec_C == i]
    G = df['LogMean'][vec_G == i]
    mean[0][i] = np.nanmean(A)
    std[0][i] = np.nanstd(A)
    mean[1][i] = np.nanmean(U)
    std[1][i] = np.nanstd(U)
    mean[2][i] = np.nanmean(C)
    std[2][i] = np.nanstd(C)
    mean[3][i] = np.nanmean(G)
    std[3][i] = np.nanstd(G)

    x = i -0.5 + 0.8*np.random.rand(len(A))
    ax5.scatter(x, A, color = color, s = s)
    # add errorbar
    a = np.nanstd(A)
    #print(a,b)
    if not (i == 9):
        ax5.errorbar([i],[mean[0][i]], yerr=[[a],[a]],fmt='r.',markersize = markersize,ecolor='red',elinewidth = 3, capsize =  capsize, capthick = 2)

    x = i -0.5 + 0.8*np.random.rand(len(U))
    ax6.scatter(x, U, color = color, s = s)
    # add errorbar
    a = np.nanstd(U)
    #print(a,b)
    if not (i == 9):
        ax6.errorbar([i],[mean[1][i]], yerr=[[a],[a]],fmt='r.',markersize = markersize, ecolor='red',elinewidth = 3, capsize =  capsize, capthick = 2)        

    x = i -0.5 + 0.8*np.random.rand(len(C))
    ax7.scatter(x, C, color = color, s = s)
    # add errorbar
    a = np.nanstd(C)
    #print(a,b)
    if not (i == 9):
        ax7.errorbar([i],[mean[2][i]], yerr=[[a],[a]],fmt='r.',markersize = markersize,ecolor='red',elinewidth = 3, capsize =  capsize, capthick = 2)        


    x = i-0.5 + 0.8*np.random.rand(len(G))
    ax8.scatter(x, G, color = color, s = s)
    # add errorbar
    a = np.nanstd(G)
    #print(a,b)
    if not (i == 9):
        ax8.errorbar([i],[mean[3][i]], yerr=[[a],[a]],fmt='r.',markersize = markersize,ecolor='red',elinewidth = 3, capsize =  capsize, capthick = 2)

### dmsc ###
mean = np.zeros((4,10))
std = np.zeros((4,10))
df = readDF('dmsc')
vec_A = np.array(list(map(lambda x: x.count('A'), df['SeqID'])))
vec_U = np.array(list(map(lambda x: x.count('U'), df['SeqID'])))
vec_C = np.array(list(map(lambda x: x.count('C'), df['SeqID'])))
vec_G = np.array(list(map(lambda x: x.count('G'), df['SeqID'])))

for i in range(10):
    A = df['LogMean'][vec_A == i] 
    U = df['LogMean'][vec_U == i]
    C = df['LogMean'][vec_C == i]
    G = df['LogMean'][vec_G == i]
    mean[0][i] = np.nanmean(A)
    std[0][i] = np.nanstd(A)
    mean[1][i] = np.nanmean(U)
    std[1][i] = np.nanstd(U)
    mean[2][i] = np.nanmean(C)
    std[2][i] = np.nanstd(C)
    mean[3][i] = np.nanmean(G)
    std[3][i] = np.nanstd(G)

    x = i -0.5 + 0.8*np.random.rand(len(A))
    ax9.scatter(x, A, color = color, s = s)
    # add errorbar
    a = np.nanstd(A)
    #print(a,b)
    if not (i == 9):
        ax9.errorbar([i],[mean[0][i]], yerr=[[a],[a]],fmt='r.',markersize = markersize,ecolor='red',elinewidth = 3, capsize =  capsize, capthick = 2)

    x = i -0.5 + 0.8*np.random.rand(len(U))
    ax10.scatter(x, U, color = color, s = s)
    # add errorbar
    a = np.nanstd(U)
    #print(a,b)
    if not (i == 9):
        ax10.errorbar([i],[mean[1][i]], yerr=[[a],[a]],fmt='r.',markersize = markersize, ecolor='red',elinewidth = 3, capsize =  capsize, capthick = 2)        

    x = i -0.5 + 0.8*np.random.rand(len(C))
    ax11.scatter(x, C, color = color, s = s)
    # add errorbar
    a = np.nanstd(C)
    #print(a,b)
    if not (i == 9):
        ax11.errorbar([i],[mean[2][i]], yerr=[[a],[a]],fmt='r.',markersize = markersize,ecolor='red',elinewidth = 3, capsize =  capsize, capthick = 2)        

    x = i-0.5 + 0.8*np.random.rand(len(G))
    ax12.scatter(x, G, color = color, s = s)
    # add errorbar
    a = np.nanstd(G)
    #print(a,b)
    if not (i == 9):
        ax12.errorbar([i],[mean[3][i]], yerr=[[a],[a]],fmt='r.',markersize = markersize,ecolor='red',elinewidth = 3, capsize =  capsize, capthick = 2)

plt.ylim(0,ymax)
plt.xticks([0,3,6,9])
plt.yticks(np.arange(0, ymax+(ymax-0)/(yticks-1), (ymax-0)/(yticks-1)))
# plt.savefig('nucleotide_trend_scatter_all.tif')    
plt.show()

