### Mutation Dataframe ====
## (i, j): 0A, 1C, 2G, 3U
SubDF <- function(Exp, site, i, j){
  if(i == j){return(NA)}
  n <- length(Exp)
  index1 <- which(0:(n-1)%/%4^(9-site)%%4 == i)
  index2 <- which(0:(n-1)%/%4^(9-site)%%4 == j)
  DF <- data.frame(Exp[index1], Exp[index2] - Exp[index1])
  colnames(DF) <- c("x", "y")
  
  ## Clear NA
  DF <- DF[which(!is.na(DF$x)), ]
  DF <- DF[which(!is.na(DF$y)), ]
  
  return(DF)
}

### Boxplot Dataframe ====
BoxDF <- function(Exp, DF, Min, Max){
  ## Boxplot Dataframe
  n <- 20
  BDF <- data.frame(matrix(NA, n, 5))
  colnames(BDF) <- c("XMean", "YMean", "YQ1", "YMedian", "YQ3")
  R <- Max - Min
  r <- R/n
  for(k in 0:(n-1)){
    indexBG <- which(DF$x>=k*r+Min & DF$x<=(k+1)*r+Min)
    BDF$XMean[k+1] <- mean(DF$x[indexBG])
    BDF$YMean[k+1] <- mean(DF$y[indexBG])
    BDF$YQ1[k+1] <- as.numeric(quantile(DF$y[indexBG], 0.25, type=2))
    BDF$YMedian[k+1] <- as.numeric(quantile(DF$y[indexBG], 0.5, type=2))
    BDF$YQ3[k+1] <- as.numeric(quantile(DF$y[indexBG], 0.75, type=2))
  }
  return(BDF)
}

### MutationMean ====
MutationMean <- function(f, lib_type, i, j){
  PlotMat <- data.frame(matrix(data=NA, nrow=20, ncol=10))
  colnames(PlotMat) <- c("Initial_Expression", paste0("Expression_Change_Position", 1:9))
  if(lib_type == "total"){
    Data <- read.table(file=paste0("../Table_ReadCount/", f, "_SDR_union_count25.csv"), header=T, sep=",")
  }
  else if(lib_type == "N2"){
    Data <- read.table(file=paste0("../Table_Prediction/", f, "_SDR_union_count25_o2.csv"), header=T, sep=",")
  }
  
  if(length(Data$LogMean) == 4^9){
    Exp <- Data$LogMean
    Xlim <- c(0, 3.2)
    Ylim <- c(-1.8, 1.8)
  }
  if(length(Data$dG) == 4^9){
    Exp <- -Data$dG
    Xlim <- c(0, 14)
    Ylim <- c(-8, 0)
  }
  
  ## Calculation
  BinMean <- seq(Xlim[1], Xlim[2], (Xlim[2]-Xlim[1])/20)
  BinMean <- rowMeans(cbind(BinMean[1:20], BinMean[2:21]))
  PlotMat[, 1] <- BinMean
  for(site in 1:9){
    SDF <- SubDF(Exp, site, i, j)
    BDF <- BoxDF(Exp, DF=SDF, Min=Xlim[1], Max=Xlim[2])
    PlotMat[, site+1] <- BDF$YMean
  }
  return(PlotMat)
}

### Plotting ====
Plotting <- function(lib, lib_type, i, j, format='svg', Xlim=c(0.0, 3.2), Ylim=c(-2.7, 0.9, 0.9)){
  PlotMat <- MutationMean(lib, lib_type, i, j)
  
  N <- c("A", "C", "G", "U")
  line_lty <- c(1, 1, 1, 1, 1, 2, 2, 2, 2)
  line_col <- c("#2f9a46", "#24aae2", "#e1dd16", 
                "#fcb040", "#ee1c25", "#fcb040", 
                "#e1dd16", "#24aae2", "#2f9a46")
  if(format=='svg'){
    svg(filename=paste0(lib, "_", lib_type, "_", N[i+1], "to", N[j+1], "_Mean.svg"), width=3, height=6)
    par(mai=c(.2, .1, .2, .1))
    plot(0, 0, type='n', xlim=Xlim, ylim=Ylim[1:2], axes=F, xaxs="i", yaxs="i", xlab="", ylab="", main="")
    axis(side=1, at=seq(Xlim[1], Xlim[2], (Xlim[2]-Xlim[1])/4), cex.axis=1.2, font.axis=2, labels=FALSE)
    axis(side=2, at=round(seq(Ylim[1], Ylim[2], Ylim[3]), digits=1), cex.axis=1.2, font.axis=2, labels=FALSE)
    box()
    for(k in 1:9){
      lines(PlotMat[, 1], PlotMat[, k+1], type="l", lwd=3, lty=1, col=line_col[k])
    }
  }
  else if(format=='tiff'){
    tiff(filename=paste0(lib, "_", lib_type, "_", N[i+1], "to", N[j+1], "_Mean.tiff"),
         width=270, height=540, units="px")
    plot(0, 0, type='n', xlim=Xlim, ylim=Ylim[1:2], axes=F, xaxs="i", yaxs="i", xlab="", ylab="", main="")
    axis(side=1, at=seq(Xlim[1], Xlim[2], (Xlim[2]-Xlim[1])/4), cex.axis=1.2, font.axis=2)
    axis(side=2, at=round(seq(Ylim[1], Ylim[2], Ylim[3]), digits=1), cex.axis=1.2, font.axis=2)
    box()
    for(k in 1:9){
      lines(PlotMat[, 1], PlotMat[, k+1], type="l", lwd=3, lty=line_lty[k], col=line_col[k])
    }
  }
  else{
    print('figure format error!')
  }
  dev.off()
  
  ## Export Table
  write.table(x=PlotMat, file=paste0(lib, "_", lib_type, "_", N[i+1], "to", N[j+1], "_Mean.csv"),
              sep=",", quote=F, row.names=F)
}

### ====
## (i, j): A:0, C:1, G:2, U:3
#PlotMat <- Plotting("fepb", "total", i=2, j=1, format="svg")
#PlotMat <- Plotting("fepb", "N2", i=2, j=1, format="svg")
#PlotMat <- Plotting("arti", "total", i=2, j=1, format="svg")
#PlotMat <- Plotting("arti", "N2", i=2, j=1, format="svg")
#PlotMat <- Plotting("dmsc", "total", i=2, j=1, format="svg")
#PlotMat <- Plotting("dmsc", "N2", i=2, j=1, format="svg")
#PlotMat <- Plotting("fepb", "total", i=2, j=1, format="tiff")
#PlotMat <- Plotting("fepb", "N2", i=2, j=1, format="tiff")
#PlotMat <- Plotting("arti", "total", i=2, j=1, format="tiff")
#PlotMat <- Plotting("arti", "N2", i=2, j=1, format="tiff")
#PlotMat <- Plotting("dmsc", "total", i=2, j=1, format="tiff")
#PlotMat <- Plotting("dmsc", "N2", i=2, j=1, format="tiff")

PlotMat <- Plotting("fepb", "total", i=1, j=2, format="svg", Ylim=c(-2.1, 1.4, 0.7))
PlotMat <- Plotting("fepb", "N2", i=1, j=2, format="svg", Ylim=c(-2.1, 1.4, 0.7))
PlotMat <- Plotting("arti", "total", i=1, j=2, format="svg", Ylim=c(-2.1, 1.4, 0.7))
PlotMat <- Plotting("arti", "N2", i=1, j=2, format="svg", Ylim=c(-2.1, 1.4, 0.7))
PlotMat <- Plotting("dmsc", "total", i=1, j=2, format="svg", Ylim=c(-2.1, 1.4, 0.7))
PlotMat <- Plotting("dmsc", "N2", i=1, j=2, format="svg", Ylim=c(-2.1, 1.4, 0.7))
PlotMat <- Plotting("fepb", "total", i=2, j=1, format="svg", Ylim=c(-2.1, 1.4, 0.7))
PlotMat <- Plotting("fepb", "N2", i=2, j=1, format="svg", Ylim=c(-2.1, 1.4, 0.7))
PlotMat <- Plotting("arti", "total", i=2, j=1, format="svg", Ylim=c(-2.1, 1.4, 0.7))
PlotMat <- Plotting("arti", "N2", i=2, j=1, format="svg", Ylim=c(-2.1, 1.4, 0.7))
PlotMat <- Plotting("dmsc", "total", i=2, j=1, format="svg", Ylim=c(-2.1, 1.4, 0.7))
PlotMat <- Plotting("dmsc", "N2", i=2, j=1, format="svg", Ylim=c(-2.1, 1.4, 0.7))
