import numpy as np
import pandas as pd
import matplotlib.pyplot as plt
from util import *

def correlationPlot(library, order, c):
    df1 = readPredictDF(library, order)
    df2 = readDF(library)

    plt.xlim(0, 3.2)
    plt.ylim(0, 3.2)
    plt.xticks(np.arange(0, 3.3, 0.8))
    plt.yticks(np.arange(0, 3.3, 0.8))
    plt.scatter(df1["LogMean"], df2["LogMean"], c=c, s=0.1)
    plt.show()

correlationPlot('fepb', 1, 'b')
correlationPlot('fepb', 2, 'r')
correlationPlot('arti', 1, 'b')
correlationPlot('arti', 2, 'r')
correlationPlot('dmsc', 1, 'b')
correlationPlot('dmsc', 2, 'r')
