import numpy as np
import pandas as pd
import matplotlib.pyplot as plt
from util import *

### =======================================
def NComposition(library, genotypes, phenotypes, n_bin=20, xlim=(0, 3.2)):
    ## grouping
    columnList = ['A_ratio', 'C_ratio', 'G_ratio', 'U_ratio']
    dfPlot = pd.DataFrame(np.zeros((n_bin, len(columnList))), columns=columnList)
    boundary = np.arange(xlim[0], xlim[1]+0.0001, (xlim[1]-xlim[0])/n_bin)
    for i in tqdm(range(n_bin)):
        indexGroup = [boundary[i]<=a<boundary[i+1] for a in phenotypes]
        # print(indexGroup)
        if sum(indexGroup)==0: continue
        # print(genotypes[indexGroup])
        NucleotidePool = ''.join(genotypes[indexGroup])
        dfPlot.loc[i, 'A_ratio'] = sum([N=='A' for N in NucleotidePool]) / len(NucleotidePool)
        dfPlot.loc[i, 'C_ratio'] = sum([N=='C' for N in NucleotidePool]) / len(NucleotidePool)
        dfPlot.loc[i, 'G_ratio'] = sum([N=='G' for N in NucleotidePool]) / len(NucleotidePool)
        dfPlot.loc[i, 'U_ratio'] = sum([N=='U' for N in NucleotidePool]) / len(NucleotidePool)
    print(dfPlot)
    ## plotting
    index = np.arange(n_bin)
    width = 1
    plt.xlim((index[0], index[-1]+1))
    plt.ylim((0, 1))
    plt.xticks(np.arange(n_bin+1), [str(round(a, 1)) for a in boundary])
    plt.bar(index+0.5, dfPlot['A_ratio'], width, color='g', edgecolor='white')
    plt.bar(index+0.5, dfPlot['U_ratio'], width, bottom=dfPlot['A_ratio'], color='r',  edgecolor='white')
    plt.bar(index+0.5, dfPlot['C_ratio'], width, bottom=dfPlot['A_ratio']+dfPlot['U_ratio'], color='b', edgecolor='white')
    plt.bar(index+0.5, dfPlot['G_ratio'], width, bottom=dfPlot['A_ratio']+dfPlot['U_ratio']+dfPlot['C_ratio'], color='k', edgecolor='white')
    plt.savefig(library+'_Composition.svg')
    plt.show()

### =======================================
def CompositionPlot(library):
    df = readDF(library)
    NComposition(library, df['SeqID'], df['LogMean'])

### =======================================
CompositionPlot('fepb')
CompositionPlot('arti')
CompositionPlot('dmsc')
