import numpy as np
import pandas as pd
import matplotlib.pyplot as plt
from tqdm import tqdm

# library = 'arti'
def Plot(library, xlim=(0, 3.2)):
	x = np.load(library+'_ReferenceFitness.npy')
	print(x.shape)
	indexNA = np.isnan(x)
	x = x[~indexNA]
	print(x.shape)
	y = np.load(library+'_BNDcount.npy')
	n_group = 20


	df_Fold = pd.read_csv('RNAfold_'+library+'_SeqFold.csv')
	print('>> '+library+' fold dG')
	print('mean = '+str(np.mean(df_Fold.loc[~indexNA, 'dG'])))
	print('std = '+str(np.std(df_Fold.loc[~indexNA, 'dG'])))

	## grouping
	# columnList = ['Xmean', 'Bmean', 'Berror', 'Nmean', 'Nerror', 'Dmean', 'Derror']
	# dfPlot = pd.DataFrame(np.full((n_group, len(columnList)), np.nan), columns=columnList)
	# boundary = np.arange(xlim[0], xlim[1]+0.0001, xlim[1]/n_group)
	# for i in tqdm(range(n_group)):
	# 	indexGroup = [boundary[i]<=a<boundary[i+1] for a in x]
	# 	if sum(indexGroup)==0: continue
	# 	dfPlot.loc[i, 'Xmean'] = np.mean(x[indexGroup])
	# 	dfPlot.loc[i, 'Bmean'] = np.mean(y[0, indexGroup])
	# 	dfPlot.loc[i, 'Berror'] = np.std(y[0, indexGroup])
	# 	dfPlot.loc[i, 'Nmean'] = np.mean(y[1, indexGroup])
	# 	dfPlot.loc[i, 'Nerror'] = np.std(y[1, indexGroup])
	# 	dfPlot.loc[i, 'Dmean'] = np.mean(y[2, indexGroup])
	# 	dfPlot.loc[i, 'Derror'] = np.std(y[2, indexGroup])
	# print(dfPlot)

	## plotting
	# plt.figure()
	# plt.xlim(xlim)
	# plt.ylim((0, 27))
	# plt.xticks(np.arange(xlim[0], xlim[1]+0.001, 0.8))
	# plt.yticks(np.arange(0, 27+0.001, 9))
	# plt.errorbar(dfPlot.Xmean, dfPlot.Nmean, dfPlot.Nerror, color='k', elinewidth=.5, capsize=4, lw=4)
	# plt.errorbar(dfPlot.Xmean+0.02, dfPlot.Dmean, dfPlot.Derror, color='b', elinewidth=.5, capsize=4, lw=4)
	# plt.errorbar(dfPlot.Xmean-0.02, dfPlot.Bmean, dfPlot.Berror, color='r', elinewidth=.5, capsize=4, lw=4)
	# plt.savefig(library+'_BNDtrend.svg')

Plot('dmsc')
Plot('arti')
Plot('fepb')
# Plot('yfp', xlim=(0, 2.7))
# Plot('Vienna', xlim=(0, 14))


