import numpy as np
import pandas as pd
from tqdm import tqdm

import os
dirname = os.path.dirname(os.path.abspath(__file__))

# library = 'arti'
def BNDcount(library):
	ReferenceFitness = np.load(library+'_ReferenceGenotypeFitness.npy')
	NeighborFitness = np.load(library+'_NeighborFitness.npy')
	indexNA = np.isnan(ReferenceFitness)
	ReferenceFitness = ReferenceFitness[~indexNA]
	NeighborFitness = NeighborFitness[~indexNA]
	print(ReferenceFitness.shape)
	print(NeighborFitness.shape)

	# df = pd.read_csv(dirname+'/../ReadCountTable_20190130/'+library+'_SDR_union_count25.csv')
	# std = np.mean(df.loc[~indexNA, ['Rep1','Rep2','Rep3']].std(axis=1))
	# print(std)
	std = 0.1

	B = [sum(NeighborFitness[i]-ReferenceFitness[i]>std) for i in tqdm(range(len(ReferenceFitness)))]
	N = [sum(abs(NeighborFitness[i]-ReferenceFitness[i])<std) for i in tqdm(range(len(ReferenceFitness)))]
	D = [sum(ReferenceFitness[i]-NeighborFitness[i]>std) for i in tqdm(range(len(ReferenceFitness)))]

	BNDcount = np.array([B, N, D], dtype=np.int8)
	np.save(library+'_BNDcount', BNDcount)

# BNDcount('dmsc')
# BNDcount('arti')
# BNDcount('fepb')
BNDcount('yfp')
# BNDcount('Vienna')




