import math
import numpy as np
import matplotlib.pyplot as plt
from tqdm import tqdm
from scipy.stats import pearsonr

# library = 'fepB'
def Plot(library, xylim=(0, 3.2), tick=0.8):
	NeighborFitness = np.load(library+'_NeighborFitness.npy')
	ReferenceFitness = np.load(library+'_ReferenceFitness.npy')

	print(NeighborFitness.shape)
	print(ReferenceFitness.shape)

	NeighborFitnessMean = [np.nanmean(NeighborFitness[i]) for i in tqdm(range(262144))]
	x = np.repeat(ReferenceFitness, 27)
	y = NeighborFitness.reshape((262144*27))
	x = x[~np.isnan(x)]
	y = y[~np.isnan(y)]
	x2 = ReferenceFitness
	y2 = np.array(NeighborFitnessMean)
	x2 = x2[~np.isnan(x2)]
	y2 = y2[~np.isnan(y2)]

	with open('Document.txt', 'a') as f:
		f.write('> '+library+'\n')
		f.write(f'x = {len(x)}\n')
		f.write(f'y = {len(y)}\n')
		f.write(f'x2 = {len(x2)}\n')
		f.write(f'y2 = {len(y2)}\n')
		Pearson_r, p_value = pearsonr(x, y)
		f.write(f'Pearson_r of neighbor total fitness: {Pearson_r}\n')
		f.write(f'p_value of neighbor total fitness: {p_value}\n')
		Pearson_r, p_value = pearsonr(x2, y2)
		f.write(f'Pearson_r of neighbor mean fitness: {Pearson_r}\n')
		f.write(f'p_value of neighbor mean fitness: {p_value}\n\n')

	plt.figure(figsize=(1.8, 1.8), dpi=300)
	plt.xlim(xylim)
	plt.ylim(xylim)
	plt.xticks(ticks=np.arange(xylim[0], xylim[1]+0.001, tick))
	plt.yticks(ticks=np.arange(xylim[0], xylim[1]+0.001, tick))
	plt.scatter(x, y, s=1, c='mediumblue', marker='.', edgecolors='none', alpha=0.5)
	# for i in tqdm(range(27)):
	# 	plt.scatter(ReferenceFitness, NeighborFitness[:,i], s=1., c='blue', marker='.', edgecolors='none', alpha=0.5)
	# plt.scatter(x2, y2, marker='.', s=2, c='red', edgecolors='none')
	plt.savefig(library+'_NeighborFitness_Background.tiff')
	# plt.show()

Plot('dmsc')
Plot('arti')
Plot('fepb')
# Plot('dmsc_shuffle')
# Plot('arti_shuffle')
# Plot('fepb_shuffle')
# Plot('yfp', xylim=(0, 2.7), tick=0.9)
# Plot('Vienna', xylim=(0, 14), tick=14/4)

