import numpy as np
import pandas as pd
import matplotlib.pyplot as plt
from util import *

def correlationPlot(library1, library2):
    df1 = readDF(library1)
    df2 = readDF(library2)

    plt.xlim(0, 3.2)
    plt.ylim(0, 3.2)
    plt.xticks(np.arange(0, 3.3, 0.8))
    plt.yticks(np.arange(0, 3.3, 0.8))
    plt.scatter(df1["LogMean"], df2["LogMean"], c='g', s=4)
    plt.show()

correlationPlot('fepb', 'arti')
correlationPlot('arti', 'dmsc')
correlationPlot('dmsc', 'fepb')
