### ====
ViennaCompare <- function(filename, cex=2){
  df <- read.table(file=paste0(filename, '_plot.csv'), header=T, sep=",")
  
  x <- df$LogMean
  y <- -df$dG
  
  print(paste0('min(x) = ', min(x, na.rm=T)))
  print(paste0('max(x) = ', max(x, na.rm=T)))
  print(paste0('min(y, na.rm=T) = ', min(y, na.rm=T)))
  print(paste0('max(y, na.rm=T) = ', max(y, na.rm=T)))
  
  n <- 20
  xLim <- 3.2
  yLim <- 15
  BoxDF <- data.frame(matrix(data=NA, nrow=n, ncol=6))
  colnames(BoxDF) <- c("XMean", "YMean", "YSD", "YQ1", "YMedian", "YQ3")
  BinList <- seq(0, xLim, xLim/n)
  for(i in 1:n){
    index <- which(BinList[i]<x & x<BinList[i+1])
    BoxDF$XMean[i] <- mean(x[index], na.rm=T)
    BoxDF$YMean[i] <- mean(y[index], na.rm=T)
    BoxDF$YSD[i] <- sd(y[index], na.rm=T)
    BoxDF$YQ1[i] <- as.numeric(quantile(y[index], 0.25, type=2, na.rm=T))
    BoxDF$YMedian[i] <- as.numeric(quantile(y[index], 0.5, type=2, na.rm=T))
    BoxDF$YQ3[i] <- as.numeric(quantile(y[index], 0.75, type=2, na.rm=T))
  }
  
  pearson_r <- round(cor.test(x, y, method="pearson", exact=FALSE)$estimate, 3)
  spearman_r <- round(cor.test(x, y, method="spearman", exact=FALSE)$estimate, 3)
  f = paste0(filename, "_pearson=", pearson_r, "_spearman=", spearman_r, ".tiff")
  tiff(filename=f, width=420, height=445, units="px")
  
  plot(x, y, pch=".", xlab="", ylab="", xlim=c(0, xLim), ylim=c(-5, yLim), axes=FALSE, xaxs="i", yaxs="i", col="gray64", cex=cex)
  axis(side=1, at=seq(0, xLim, xLim/4), cex.axis=1.5)
  axis(side=2, at=c(seq(-5, yLim, yLim/3)), cex.axis=1.5)
  box()
  arrows(x0=BoxDF$XMean, y0=BoxDF$YQ1, x1=BoxDF$XMean, y1=BoxDF$YQ3, lwd=9, angle=90, code=0, col="green") # Q1-Q3
  points(x=BoxDF$XMean, y=BoxDF$YMedian, pch=20, col="blue", cex=2.5) # Median
  points(x=BoxDF$XMean, y=BoxDF$YMean, pch=20, col="red", cex=2.5) # Mean
  
  print(pearson_r)
  print(spearman_r)
  
  dev.off()
}

### ====
#ViennaCompare("RNAfold_fepB_fepB")
#ViennaCompare("RNAfold_arti_arti")
#ViennaCompare("RNAfold_dmsC_dmsC")
ViennaCompare("RNAsubopt_fepB")
ViennaCompare("RNAsubopt_arti")
ViennaCompare("RNAsubopt_dmsC")














