def plotTable(library_dG, library_Exp, header):
	import pandas as pd
	df_Fold = pd.read_csv(library_dG+'_dG.csv')
	df_ReadCount = readDF(library_Exp)
	print(df_Fold.head(), '\n', df_ReadCount.head())

	import matplotlib.pyplot as plt
	df = pd.concat([df_Fold.dG, df_ReadCount.LogMean], axis=1)
	print(df.head())
	print(df.corr().iloc[0,1])
	# plt.scatter(df_Fold.dG, df_ReadCount.LogMean, s=0.01)
	# plt.show()
	df.to_csv(library_dG+'_'+library_Exp+'_plot.csv', index=False)

	from scipy.stats import pearsonr
	dfCor = df.dropna()
	Pearson_r, p_value = pearsonr(dfCor.dG, dfCor.LogMean)

	import numpy as np
	with open('Document.txt', 'a') as f:
		f.write(header+'\n')
		f.write(f'mean: {np.mean(df["dG"])}\n')
		f.write(f'std: {np.std(df["dG"])}\n')
		f.write(f'median: {np.median(df["dG"])}\n')
		f.write(f'95%_min: {np.percentile(df["dG"], 5)}\n')
		f.write(f'95%_max: {np.percentile(df["dG"], 95)}\n')
		f.write(f'99%_min: {np.percentile(df["dG"], 1)}\n')
		f.write(f'99%_max: {np.percentile(df["dG"], 99)}\n')
		f.write(f'99.9%_min: {np.percentile(df["dG"], 0.1)}\n')
		f.write(f'99.9%_max: {np.percentile(df["dG"], 99.9)}\n')
		f.write(f'99.99%_min: {np.percentile(df["dG"], 0.01)}\n')
		f.write(f'99.99%_max: {np.percentile(df["dG"], 99.99)}\n')
		f.write(f'Pearson_r: {Pearson_r}\n')
		f.write(f'p_value: {p_value}\n\n')


# plotTable('RNAfold_fepB', 'fepB', '>fepB_fold_dG')
# plotTable('RNAfold_arti', 'arti', '>arti_fold_dG')
# plotTable('RNAfold_dmsC', 'dmsC', '>dmsC_fold_dG')
plotTable('RNAsubopt', 'fepB', '>fepB_SD:aSD_dG')
plotTable('RNAsubopt', 'arti', '>arti_SD:aSD_dG')
plotTable('RNAsubopt', 'dmsC', '>dmsC_SD:aSD_dG')

'''
>fepB_fold_dG
mean:
median:
95%_min:
95%_max:
99%_min:
99%_max:
99.9%_min:
99.9%_max:
99.99%_min:
99.99%_max:
'''