#! /usr/bin/env perl
   use strict;
   use 5.010;
   use autodie;
   use Getopt::Long;
   my($in,$list,$out,$help,$total);
   GetOptions("in=s"=>\$in,"list=s"=>\$list,"out=s"=>\$out,"help"=>\$help,"total=s"=>\$total);
   if($in and $list and $out and $total){
     open IN,'<',$in;
     open LIST,'<',$list;
     open OUT,'>',$out;

     my %pres;
     while(<LIST>){
       unless(m/^miRNA/){
         chomp;
         my @lines=split(/\t/,$_);
         $pres{$lines[1]}{$lines[0]}=1;
      }
    }
     close LIST;

     my %res;
     while(<IN>){
       unless($_ =~ m/^#/ or $_ =~ m/^Geneid/){
         chomp;
         my @lines=split(/\t/,$_);
         if($pres{$lines[0]}){
           my $val=$lines[-1]*1000000/$total;
           foreach(sort keys %{$pres{$lines[0]}}){
             if((not $res{$_}) or $res{$_}<$val){
               $res{$_}=$val;
            }
          }
        }
      }
    }
     close IN;
     print OUT "Gene\tCPM\n";
     foreach(sort keys %res){
       print OUT $_."\t".$res{$_}."\n";
    }
     close OUT;


   }elsif($help){
      say"This script aims to count the CPM of sequenced miRNAs!\n\n
      --in:the input file;\n
      --total:the total mapped reads;\n
      --list:the sequenced miRNAs list file;\n
      --out:the result file;\n
      --help:the help!\n";
   }else{
      print "Please read the help!\n";
   }
