#! /usr/bin/env perl
   use strict;
   use 5.010;
   use autodie;
   use Getopt::Long;
   my($in,$gtf,$list,$out,$help,$total);
   GetOptions("in=s"=>\$in,"gtf=s"=>\$gtf,"list=s"=>\$list,"out=s"=>\$out,"help"=>\$help,"total=s"=>\$total);
   if($in and $gtf and $list and $out and $total){
     open IN,'<',$in;
     open GTF,'<',$gtf;
     open LIST,'<',$list;
     open OUT,'>',$out;

     my %pres;
     while(<LIST>){
       unless(m/^miRNA/){
         chomp;
         my @lines=split(/\t/,$_);
         $pres{$lines[3]}=1;
      }
    }
     close LIST;

     my %ids;
     my %mats;
     while(<GTF>){
       unless(m/^#/){
         chomp;
         my @lines=split(/\t/,$_);
         my $id;
         my $name;
         if($lines[2] eq 'miRNA_primary_transcript'){
           foreach(split(/\;/,$lines[-1])){
             if(m/^ID=/){
               $id=substr($_,3);
            }elsif(m/^Name=/){
               $name=substr($_,5);
            }
          }
           if($pres{$name}){
             $ids{$id}=1;
          }
        }elsif($lines[2] eq 'miRNA'){
           foreach(split(/\;/,$lines[-1])){
             if(m/^Name=/){
               $name=substr($_,5);
            }elsif(m/^Derives_from=/){
               $id=substr($_,13);
            }
          }
           if($ids{$id}){
             $mats{$name}=1;
          }
        }
      }
    }
     close GTF;

     while(<IN>){
       unless($_ =~ m/^#/ or $_ =~ m/^Geneid/){
         chomp;
         my @lines=split(/\t/,$_);
         if($mats{$lines[0]}){
           print OUT $lines[0]."\t".($lines[-1]*1000000/$total)."\n";
        }
      }
    }
     close IN;
     close OUT;


   }elsif($help){
      say"This script aims to count the CPM of sequenced miRNAs!\n\n
      --in:the input file;\n
      --gtf:the gff file;\n
      --total:the total mapped reads;\n
      --list:the sequenced miRNAs list file;\n
      --out:the result file;\n
      --help:the help!\n";
   }else{
      print "Please read the help!\n";
   }
