#! /usr/bin/env perl
   use strict;
   use 5.010;
   use autodie;
   use Getopt::Long;
   my($in,$gtf,$out,$help);
   GetOptions("in=s"=>\$in,"gtf=s"=>\$gtf,"out=s"=>\$out,"help"=>\$help);
   if($in and $gtf and $out){
     open IN,'<',$in;
     open GTF,'<',$gtf;
     open OUT,'>',$out;

     my %ans;
     while(<GTF>){
       chomp;
       my @lines=split(/\t/,$_);
       if($lines[2] eq 'gene'){
         $ans{$lines[0]."\t".$lines[6]}{$lines[3]}{$lines[4]}=$_;
      }
    }
     close GTF;

     while(<IN>){
       chomp;
       my @lines=split(/\t/,$_);
       my $strand=$lines[-1] eq '+'?'-':'+';
       foreach my $beg(sort {$a<=>$b} keys %{$ans{$lines[0]."\t".$strand}}){
         if($beg<=$lines[2]){
           foreach my $end(sort {$a<=>$b} keys %{$ans{$lines[0]."\t".$strand}{$beg}}){
             if($end>=$lines[1]){ 
               print OUT $lines[3]."\t".$ans{$lines[0]."\t".$strand}{$beg}{$end}."\n";
            }
          }
        }else{
           last;
        }
      }
    }
     close IN;
     close OUT;
   }elsif($help){
      say"This script aims to annotate the AT-miRNAs using FANTOM5 data!\n\n
      --in:the input file;\n
      --gtf:the gtf file;\n
      --out:the result file;\n
      --help:the help!\n";
   }else{
      print "Please read the help!\n";
   }
