setwd("")
dat<-read.table(file="FANTOM5_1v1_raw_AT_div_res_new_gene_exp_res_strand",header = T,stringsAsFactors = F,na.strings = "NA",sep = "\t")
library(ggpubr)
library(ggplot2)
library(gridExtra)
dat_1<-subset(dat,dat$WT>=5 | dat$KO>=5)

dat_1_ed<-data.frame(FPKM=c(dat_1$WT[dat_1$Group=="10" & dat_1$Top<=500],
                            dat_1$KO[dat_1$Group=="10" & dat_1$Top<=500]),
                     Type=c(rep("Control",length(dat_1$WT[dat_1$Group=="10" & dat_1$Top<=500])),
                            rep("KO",length(dat_1$KO[dat_1$Group=="10" & dat_1$Top<=500]))))

p1<-ggpaired(dat_1_ed, x = "Type", y = "FPKM",
         color = "black", line.color = "gray",line.size = 0.5,point.size = 0.8,
         palette = "jco")
dat_2_ed<-data.frame(FPKM=c(dat_1$WT[(dat_1$Group=="5~10" | dat_1$Group=="2~5") & dat_1$Top<=500],
                            dat_1$KO[(dat_1$Group=="5~10" | dat_1$Group=="2~5") & dat_1$Top<=500]),
                     Type=c(rep("Control",length(dat_1$WT[(dat_1$Group=="5~10" | dat_1$Group=="2~5") & dat_1$Top<=500])),
                            rep("KO",length(dat_1$KO[(dat_1$Group=="5~10" | dat_1$Group=="2~5") & dat_1$Top<=500]))))

p2<-ggpaired(dat_2_ed, x = "Type", y = "FPKM",
             color = "black", line.color = "gray",line.size = 0.5,point.size = 0.8,
             palette = "jco")
dat_1_un<-data.frame(FPKM=c(dat_1$WT[dat_1$Group=="Control" & dat_1$Top<=500],
                            dat_1$KO[dat_1$Group=="Control" & dat_1$Top<=500]),
                     Type=c(rep("Control",length(dat_1$WT[dat_1$Group=="Control" & dat_1$Top<=500])),
                            rep("KO",length(dat_1$KO[dat_1$Group=="Control" & dat_1$Top<=500]))))

p3<-ggpaired(dat_1_un, x = "Type", y = "FPKM",
         color = "black", line.color = "gray",line.size = 0.5,point.size = 0.8,
         palette = "jco")

wilcox.test(dat_1$WT[dat_1$Group=="10" & dat_1$Top<=500],
            dat_1$KO[dat_1$Group=="10" & dat_1$Top<=500],paired = T,alternative = "greater")
wilcox.test(dat_1$WT[(dat_1$Group=="5~10" | dat_1$Group=="2~5") & dat_1$Top<=500],
            dat_1$KO[(dat_1$Group=="5~10" | dat_1$Group=="2~5") & dat_1$Top<=500],paired = T,alternative = "greater")
wilcox.test(dat_1$WT[dat_1$Group=="Control" & dat_1$Top<=500],
            dat_1$KO[dat_1$Group=="Control" & dat_1$Top<=500],paired = T,alternative = "greater")


pdf("Figure_4F.pdf")

grid.arrange(p1,p3,p2,nrow=4,ncol=6)

#p1,Level: 10%; p3,Level: <10%; p2,Intronic
dev.off()
