setwd("")

dat<-read.table(file="ADARKO_Control_merged_matrix",header = T,stringsAsFactors = F)

dat_1<-subset(dat,(dat$Control_Unedited_count+dat$Control_Edited_count)>=30 & 
                (dat$ADARKO_Unedited_count+dat$ADARKO_Edited_count)>=30 )

dat_1$Control<-dat_1$Control_Edited_count/(dat_1$Control_Unedited_count+dat_1$Control_Edited_count)
dat_1$KO<-dat_1$ADARKO_Edited_count/(dat_1$ADARKO_Unedited_count+dat_1$ADARKO_Edited_count)

dat_2<-subset(dat_1,(dat_1$KO+dat_1$Control)>0 & (dat_1$KO+dat_1$Control)<1)

t1<-wilcox.test(dat_2$KO,dat_2$Control)

pdf("Figure_4E.pdf")
par(mfrow=c(2,2),mar=c(6,6,6,6))
boxplot(dat_2$Control*100,dat_2$KO*100,
     ylab = "Editing level",main="",
     las=2,outline = F,ylim=c(0,16),
     names = c("Control","ADAR1 KO"))
legend("topleft",legend = "p = 0",bty="n")

dev.off()



