setwd("")

dat_a<-read.table(file="data",header = T,stringsAsFactors = F)


pdf("Figure_4B.pdf")
par(mfrow=c(2,2),mar=c(4,4,2,2))
plot(dat_a$edited~dat_a$unedited,ylim=c(-80,-5),cex=2,xlim=c(-80,-5),
     pch=20,col=rgb(0,0,100,100,maxColorValue=255),
     xlab = "G of unedited transcripts",main="",
     ylab="G of edited transcripts",las=1,axes=F)
axis(1,at=c(-80,-60,-40,-20,-5))
axis(2,at=c(-80,-60,-40,-20,-5),las=2)
abline(a=0,b=1,col="red")
box()
legend("topleft",legend = paste("p= ",wilcox.test(dat_a$edited,dat_a$unedited)$p.value),bty="n")
dev.off()





