setwd("")

dat<-read.table(file='HEK293T_Drosha_KD_AT_miRNAs_exonic_FPKM_res',
                 header = T,stringsAsFactors = F,sep = "\t",na.strings = "NA",row.names=1)


library(ggpubr)
library(ggplot2)
library(gridExtra)

dat_1_ed<-data.frame(FPKM=c(log2(dat$WTR1[dat$WTR1>=1 | dat$KDR1>=1]+1),
                            log2(dat$KDR1[dat$WTR1>=1 | dat$KDR1>=1]+1)),
                     Type=c(rep("WTR1",length(dat$WTR1[dat$WTR1>=1 | dat$KDR1>=1])),
                            rep("KDR1",length(dat$KDR1[dat$WTR1>=1 | dat$KDR1>=1]))))
                     
p1<-ggpaired(dat_1_ed, x = "Type", y = "FPKM",
             color = "black", line.color = "gray",line.size = 0.5,point.size = 0.8,
             palette = "jco",outline=F)


wilcox.test(dat$WTR1[dat$WTR1>=1 | dat$KDR1>=1],
            dat$KDR1[dat$WTR1>=1 | dat$KDR1>=1],paired = T)

pdf("Figure_3E.pdf")
grid.arrange(p1,nrow=3,ncol=5)

dev.off()

