setwd("")
dat<-read.table(file = "human_tissues_miRNAs_cpm_matrix",header = T,stringsAsFactors = F)

pdf("Figure_2F_miRNA.pdf")
par(mfrow=c(2,2),mar=c(4,4,1,1))

plot(log10(dat$Brain_whole[order(dat$Brain_whole,decreasing =T)][1:200]+1),type = "l",
     las=1,ylab="Log10 (cpm +1)",xlab = "Top 200 miRNAs (ranked)",ylim=c(0,5.5),lwd=2,col="#08306b")
par(new=T)
plot(log10(dat$Cerebellum[order(dat$Cerebellum,decreasing =T)][1:200]+1),type = "l",
     las=1,ylab="",xlab = "",ylim=c(0,5.5),lwd=2,col="#08519c",axes=F)
par(new=T)
plot(log10(dat$Fetal_brain[order(dat$Fetal_brain,decreasing =T)][1:200]+1),type = "l",
     las=1,ylab="",xlab = "",ylim=c(0,5.5),lwd=2,col="#2171b5",axes=F)
par(new=T)
plot(log10(dat$Fetal_liver[order(dat$Fetal_liver,decreasing =T)][1:200]+1),type = "l",
     las=1,ylab="",xlab = "",ylim=c(0,5.5),lwd=2,col="#4292c6",axes=F)
par(new=T)
plot(log10(dat$Heart[order(dat$Heart,decreasing =T)][1:200]+1),type = "l",
     las=1,ylab="",xlab = "",ylim=c(0,5.5),lwd=2,col="#6baed6",axes=F)
par(new=T)
plot(log10(dat$Kidney[order(dat$Kidney,decreasing =T)][1:200]+1),type = "l",
     las=1,ylab="",xlab = "",ylim=c(0,5.5),lwd=2,col="#9ecae1",axes=F)
par(new=T)
plot(log10(dat$Lung[order(dat$Lung,decreasing =T)][1:200]+1),type = "l",
     las=1,ylab="",xlab = "",ylim=c(0,5.5),lwd=2,col="#c6dbef",axes=F)
par(new=T)
plot(log10(dat$Muscle[order(dat$Muscle,decreasing =T)][1:200]+1),type = "l",
     las=1,ylab="",xlab = "",ylim=c(0,5.5),lwd=2,col="#deebf7",axes=F)
par(new=T)
plot(log10(dat$Placenta[order(dat$Placenta,decreasing =T)][1:200]+1),type = "l",
     las=1,ylab="",xlab = "",ylim=c(0,5.5),lwd=2,col="#fee0d2",axes=F)
par(new=T)
plot(log10(dat$Small_intestine[order(dat$Small_intestine,decreasing =T)][1:200]+1),type = "l",
     las=1,ylab="",xlab = "",ylim=c(0,5.5),lwd=2,col="#fcbba1",axes=F)
par(new=T)
plot(log10(dat$Spinal_cord[order(dat$Spinal_cord,decreasing =T)][1:200]+1),type = "l",
     las=1,ylab="",xlab = "",ylim=c(0,5.5),lwd=2,col="#fc9272",axes=F)
par(new=T)
plot(log10(dat$Spleen[order(dat$Spleen,decreasing =T)][1:200]+1),type = "l",
     las=1,ylab="",xlab = "",ylim=c(0,5.5),lwd=2,col="#fb6a4a",axes=F)
par(new=T)
plot(log10(dat$Stomach[order(dat$Stomach,decreasing =T)][1:200]+1),type = "l",
     las=1,ylab="",xlab = "",ylim=c(0,5.5),lwd=2,col="#ef3b2c",axes=F)
par(new=T)
plot(log10(dat$Testis[order(dat$Testis,decreasing =T)][1:200]+1),type = "l",
     las=1,ylab="",xlab = "",ylim=c(0,5.5),lwd=2,col="#cb181d",axes=F)
par(new=T)
plot(log10(dat$Thymus[order(dat$Thymus,decreasing =T)][1:200]+1),type = "l",
     las=1,ylab="",xlab = "",ylim=c(0,5.5),lwd=2,col="#a50f15",axes=F)
par(new=T)
plot(log10(dat$Uterus[order(dat$Uterus,decreasing =T)][1:200]+1),type = "l",
     las=1,ylab="",xlab = "",ylim=c(0,5.5),lwd=2,col="#67000d",axes=F)
legend("topright",pch=16,col = c("#08306b","#08519c","#2171b5","#4292c6",
       "#6baed6","#9ecae1","#c6dbef","#deebf7","#fee0d2","#fcbba1","#fc9272",
       "#fb6a4a","#ef3b2c","#cb181d","#a50f15","#67000d"),bty="n",lwd=2,
       legend = c("Brain(whole)","Cerebellum","Fetal brain","Fetal liver",
       "Heart","Kidney","Lung","Muscle","Placenta","Small intestine",
       "Spinal cord","Spleen","Stomach","Testis","Thymus","Uterus"),cex=0.4)


dev.off()



