setwd("")
dat<-read.table(file="data.txt",header = T,stringsAsFactors = F,sep="\t")

dat$Total<-dat$A..G+dat$T..C

pdf("Figure_1B.pdf")
par(mfrow=c(2,1),mar=c(4,6,4,2))

plot(dat$Total,col="#fc9272",las=1,ylim = c(0,1),type="h",axes = F,ylab="Proportion",xlab = "")
abline(v=1:30,col="grey")
par(new=T)
plot(dat$Total,col="#fc9272",las=1,axes = F,pch=16,ylim = c(0,1),ylab = "",xlab = "",cex=1.2)
axis(1,at=1:30,labels = dat$Type,srt=90,las=2)
axis(2,at=c(0,0.2,0.4,0.6,0.8,1),las=2)
par(new=T)
plot(dat$A..G,col="#7fcdbb",las=1,ylim = c(0,1),type="h",axes = F,ylab = "",xlab = "")
par(new=T)
plot(dat$A..G,col="#7fcdbb",las=1,axes = F,pch=16,ylim = c(0,1),ylab = "",xlab = "",cex=1.2)
legend("topleft",c("A->G","T->C"),pch = 16,col=c("#7fcdbb","#fc9272"),bty = "n",cex=1.2)

dev.off()

