#!/bin/bash

# Slurm Parameters
#SBATCH --job-name=CTC
#SBATCH --output=CTC.%A_%a.out
#SBATCH --error=CTC.%A_%a.err
#SBATCH --nodes=1
#SBATCH --ntasks=1
#SBATCH --mem=12gb
#SBATCH --time=1:00:00
#SBATCH --array=1-2

# Commands
# sbatch 1_createTable.sh
# squeue -u egadegu
# scancel 1454607

# Input
inputFileName="/usr/users/egadegu/Projects/Wendt_Stag/Code/29_TAD_Border_Conservation/input/1_ctc.txt"
parameters=`sed "${SLURM_ARRAY_TASK_ID}q;d" $inputFileName`

# Creating matrix
python /usr/users/egadegu/Projects/Wendt_Stag/Code/29_TAD_Border_Conservation/1_createTable.py $parameters


#python /usr/users/egadegu/Projects/Wendt_Stag/Code/29_TAD_Border_Conservation/1_createTable.py 25000 2 /usr/users/egadegu/Projects/Wendt_Stag/Results/4_TADs/1_TADs_GMAP/ 69_127plus/chr1/T_3_80_25_100_5_10_0.95_0.5,69_127plus/chr2/T_3_80_25_100_5_10_0.95_0.5,69_127plus/chr3/T_3_80_25_100_5_10_0.95_0.5,69_127plus/chr4/T_3_80_25_100_5_10_0.95_0.5,69_127plus/chr5/T_3_80_25_100_5_10_0.95_0.5,69_127plus/chr6/T_3_80_25_100_5_10_0.95_0.5,69_127plus/chr7/T_3_80_25_100_5_10_0.95_0.5,69_127plus/chr8/T_3_80_25_100_5_10_0.95_0.5,69_127plus/chr9/T_3_80_25_100_5_10_0.95_0.5,69_127plus/chr10/T_3_80_25_100_5_10_0.95_0.5,69_127plus/chr11/T_3_80_25_100_5_10_0.95_0.5,69_127plus/chr12/T_3_80_25_100_5_10_0.95_0.5,69_127plus/chr13/T_3_80_25_100_5_10_0.95_0.5,69_127plus/chr14/T_3_80_25_100_5_10_0.95_0.5,69_127plus/chr15/T_3_80_25_100_5_10_0.95_0.5,69_127plus/chr16/T_3_80_25_100_5_10_0.95_0.5,69_127plus/chr17/T_3_80_25_100_5_10_0.95_0.5,69_127plus/chr18/T_3_80_25_100_5_10_0.95_0.5,69_127plus/chr19/T_3_80_25_100_5_10_0.95_0.5,69_127plus/chr20/T_3_80_25_100_5_10_0.95_0.5,69_127plus/chr21/T_3_80_25_100_5_10_0.95_0.5,69_127plus/chr22/T_3_80_25_100_5_10_0.95_0.5,69_127plus/chrX/T_3_80_25_100_5_10_0.95_0.5 69_127-/chr1/T_3_80_25_100_5_10_0.95_0.5,69_127-/chr2/T_3_80_25_100_5_10_0.95_0.5,69_127-/chr3/T_3_80_25_100_5_10_0.95_0.5,69_127-/chr4/T_3_80_25_100_5_10_0.95_0.5,69_127-/chr5/T_3_80_25_100_5_10_0.95_0.5,69_127-/chr6/T_3_80_25_100_5_10_0.95_0.5,69_127-/chr7/T_3_80_25_100_5_10_0.95_0.5,69_127-/chr8/T_3_80_25_100_5_10_0.95_0.5,69_127-/chr9/T_3_80_25_100_5_10_0.95_0.5,69_127-/chr10/T_3_80_25_100_5_10_0.95_0.5,69_127-/chr11/T_3_80_25_100_5_10_0.95_0.5,69_127-/chr12/T_3_80_25_100_5_10_0.95_0.5,69_127-/chr13/T_3_80_25_100_5_10_0.95_0.5,69_127-/chr14/T_3_80_25_100_5_10_0.95_0.5,69_127-/chr15/T_3_80_25_100_5_10_0.95_0.5,69_127-/chr16/T_3_80_25_100_5_10_0.95_0.5,69_127-/chr17/T_3_80_25_100_5_10_0.95_0.5,69_127-/chr18/T_3_80_25_100_5_10_0.95_0.5,69_127-/chr19/T_3_80_25_100_5_10_0.95_0.5,69_127-/chr20/T_3_80_25_100_5_10_0.95_0.5,69_127-/chr21/T_3_80_25_100_5_10_0.95_0.5,69_127-/chr22/T_3_80_25_100_5_10_0.95_0.5,69_127-/chrX/T_3_80_25_100_5_10_0.95_0.5 /usr/users/egadegu/Projects/Wendt_Stag/Results/29_TAD_Border_Conservation/STAG1.txt

#python /usr/users/egadegu/Projects/Wendt_Stag/Code/29_TAD_Border_Conservation/1_createTable.py 25000 2 /usr/users/egadegu/Projects/Wendt_Stag/Results/4_TADs/1_TADs_GMAP/ 3B9_5plus/chr1/T_3_80_25_100_5_10_0.95_0.5,3B9_5plus/chr2/T_3_80_25_100_5_10_0.95_0.5,3B9_5plus/chr3/T_3_80_25_100_5_10_0.95_0.5,3B9_5plus/chr4/T_3_80_25_100_5_10_0.95_0.5,3B9_5plus/chr5/T_3_80_25_100_5_10_0.95_0.5,3B9_5plus/chr6/T_3_80_25_100_5_10_0.95_0.5,3B9_5plus/chr7/T_3_80_25_100_5_10_0.95_0.5,3B9_5plus/chr8/T_3_80_25_100_5_10_0.95_0.5,3B9_5plus/chr9/T_3_80_25_100_5_10_0.95_0.5,3B9_5plus/chr10/T_3_80_25_100_5_10_0.95_0.5,3B9_5plus/chr11/T_3_80_25_100_5_10_0.95_0.5,3B9_5plus/chr12/T_3_80_25_100_5_10_0.95_0.5,3B9_5plus/chr13/T_3_80_25_100_5_10_0.95_0.5,3B9_5plus/chr14/T_3_80_25_100_5_10_0.95_0.5,3B9_5plus/chr15/T_3_80_25_100_5_10_0.95_0.5,3B9_5plus/chr16/T_3_80_25_100_5_10_0.95_0.5,3B9_5plus/chr17/T_3_80_25_100_5_10_0.95_0.5,3B9_5plus/chr18/T_3_80_25_100_5_10_0.95_0.5,3B9_5plus/chr19/T_3_80_25_100_5_10_0.95_0.5,3B9_5plus/chr20/T_3_80_25_100_5_10_0.95_0.5,3B9_5plus/chr21/T_3_80_25_100_5_10_0.95_0.5,3B9_5plus/chr22/T_3_80_25_100_5_10_0.95_0.5,3B9_5plus/chrX/T_3_80_25_100_5_10_0.95_0.5 3B9_5-/chr1/T_3_80_25_100_5_10_0.95_0.5,3B9_5-/chr2/T_3_80_25_100_5_10_0.95_0.5,3B9_5-/chr3/T_3_80_25_100_5_10_0.95_0.5,3B9_5-/chr4/T_3_80_25_100_5_10_0.95_0.5,3B9_5-/chr5/T_3_80_25_100_5_10_0.95_0.5,3B9_5-/chr6/T_3_80_25_100_5_10_0.95_0.5,3B9_5-/chr7/T_3_80_25_100_5_10_0.95_0.5,3B9_5-/chr8/T_3_80_25_100_5_10_0.95_0.5,3B9_5-/chr9/T_3_80_25_100_5_10_0.95_0.5,3B9_5-/chr10/T_3_80_25_100_5_10_0.95_0.5,3B9_5-/chr11/T_3_80_25_100_5_10_0.95_0.5,3B9_5-/chr12/T_3_80_25_100_5_10_0.95_0.5,3B9_5-/chr13/T_3_80_25_100_5_10_0.95_0.5,3B9_5-/chr14/T_3_80_25_100_5_10_0.95_0.5,3B9_5-/chr15/T_3_80_25_100_5_10_0.95_0.5,3B9_5-/chr16/T_3_80_25_100_5_10_0.95_0.5,3B9_5-/chr17/T_3_80_25_100_5_10_0.95_0.5,3B9_5-/chr18/T_3_80_25_100_5_10_0.95_0.5,3B9_5-/chr19/T_3_80_25_100_5_10_0.95_0.5,3B9_5-/chr20/T_3_80_25_100_5_10_0.95_0.5,3B9_5-/chr21/T_3_80_25_100_5_10_0.95_0.5,3B9_5-/chr22/T_3_80_25_100_5_10_0.95_0.5,3B9_5-/chrX/T_3_80_25_100_5_10_0.95_0.5 /usr/users/egadegu/Projects/Wendt_Stag/Results/29_TAD_Border_Conservation/STAG2.txt

