package utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

/**
 * Method to filter the loops close to white strip or loops which don't reach the different threshold filter
 * @author axel poulet
 *
 */
public class FilterLoops {
	/** loops resoluiton*/
	private int _resolution;
	/** raw or line with biais value in the hic matrix*/
	private HashMap<Integer,String> _normVector = new HashMap<Integer,String>();
	
	/**
	 * Constructor 
	 * @param resolution
	 * @param normVector
	 */
	public FilterLoops(int resolution,HashMap<Integer,String> normVector){
		this._resolution = resolution;
		this._normVector = normVector;
	}
	
	
	/**
	 * Remove loops which doesn't respect the rule
	 * 
	 * @param input loop collection before correction
	 * @return loop collection after correction
	 */
	public HashMap<String, Loop>  removedBadLoops(HashMap<String, Loop> input){
		Set<String> key = input.keySet();
		Iterator<String> it = key.iterator();
		ArrayList<String> removed = new ArrayList<String>();
		while (it.hasNext()){
			String name = it.next();
			Loop loop = input.get(name);
			if(!(removed.contains(name))){
				// filter on APA score and APA regional score
				if(loop.getPaScoreAvg() < 1.2 || loop.getRegionalPaScoreAvg() < 1 )
					removed.add(name);
				else
					removed = removeOverlappingLoops(loop,input,removed);
			}
		}
		for (int i = 0; i< removed.size(); ++i)
			input.remove(removed.get(i));
		return input;
	}
	
	/**
	 * Removed loop close to white  strip
	 * 
	 * @param hLoop loop collection before correction of the loops
	 * @return loop collection sfter correction of the loops
	 */
	public HashMap<String,Loop> removedLoopCloseToWhiteStrip(HashMap<String,Loop> hLoop){
		Set<String> key = hLoop.keySet();
		Iterator<String> it = key.iterator();
		ArrayList<String> removed = new ArrayList<String>();
		while (it.hasNext()){
			String name = it.next();
			Loop loop = hLoop.get(name);
			Boolean testRemoved = removedVectoNorm(loop);
			boolean testBreak = false;
			if(testRemoved)
				removed.add(name);
			else{
				String [] tname = name.split("\t");
				//System.out.println(name);
				int x = Integer.parseInt(tname[1]);
				int y = Integer.parseInt(tname[2]);
				for(int i = x-5*this._resolution; i <= x+5*this._resolution; i+=this._resolution){
					for(int j = y-5*this._resolution; j <= y+5*this._resolution; j+=this._resolution){
						String test = tname[0]+"\t"+i+"\t"+j;
						if(!test.equals(name)){
							if(hLoop.containsKey(test)){
								if(hLoop.get(test).getResolution() < hLoop.get(name).getResolution()){
									removed.add(name);
									testBreak =true;
									break;
								}else if(hLoop.get(test).getResolution() == hLoop.get(name).getResolution()){
									if((Math.abs(x-hLoop.get(test).getX()) < this._resolution*3 || Math.abs(y-hLoop.get(test).getY()) < this._resolution*3)){
										if(hLoop.get(test).getAvg() > hLoop.get(name).getAvg()){
											removed.add(name);
											testBreak =true;
											break;
										}else if(hLoop.get(test).getAvg() < hLoop.get(name).getAvg())
											removed.add(test);
										else{
											if(hLoop.get(test).getPaScoreAvg() > hLoop.get(name).getPaScoreAvg()){
												removed.add(name);
												testBreak =true;
												break;
											}else
												removed.add(test);
										}
									}
								}else
									removed.add(test);
							}
						}
					}
					if(testBreak)
						break;
				}
			}
		}
		for (int i = 0; i< removed.size(); ++i)
			hLoop.remove(removed.get(i));
		return hLoop;
	}
	
	/**
	 * Removed loops close to biased HiC signal
	 * @param loop Loop to test
	 * @return boolean true if loop have to be removed else false
	 */
	private boolean removedVectoNorm(Loop loop){
		boolean test = false;
		int x = loop.getCoordinates().get(0);
		int y = loop.getCoordinates().get(2);
		if(loop.getResolution() == this._resolution){
			if(this._normVector.containsKey(x) || this._normVector.containsKey(y))
				test = true;
		}
		else if(loop.getResolution() == this._resolution*2){
			if(this._normVector.containsKey(x) || this._normVector.containsKey(y) ||this._normVector.containsKey(x+this._resolution) || this._normVector.containsKey(y+this._resolution))
				test = true;
		}
		else if(loop.getResolution() == this._resolution*5){
			for(int i = x; i <= x+5*this._resolution; i+=this._resolution){
				if(this._normVector.containsKey(i)){
					test = true;
					break;
				}
				for(int j = y; j <= y+5*this._resolution; j+=this._resolution){
					if(this._normVector.containsKey(j)){
						test = true;
						break;
					}
				}		
			}
		}
		return test;
	}

	
	/**
	 * Remove overlapping loops
	 * @param loop loop to test
	 * @param input loop collection
	 * @param removed arrayList of loop
	 * @return removed arrayList of loop 
	 */
	private ArrayList<String> removeOverlappingLoops(Loop loop, HashMap<String, Loop> input, ArrayList<String> removed){
		Set<String> key = input.keySet();
		Iterator<String> it = key.iterator();
		while (it.hasNext()){
			String name = it.next();
			Loop looptest = input.get(name);
			if(!(removed.contains(name)) && loop.getResolution() < looptest.getResolution()){
				int factor = looptest.getResolution()/loop.getResolution();
				int xtest = loop.getX()/factor;
				int ytest = loop.getY()/factor;
				for(int i = xtest-1; i <= xtest+1; ++i ){
					for(int j = ytest-1; j <= ytest+1; ++j ){
						if(i == looptest.getX() && j == looptest.getY()){
							removed.add(name);
						}
					}
				}
			}
		}
		return removed;
	}
}