# Run network edge diffusion based on node diffused values
# REQUIRED PYTHON AND MATLAB
set -u


B=$1		# beta parameter; e.g., 0.5
EDGELIST=$2	# edgelist (i.e., network)
IDX=$3		# gene index file (format: index [tab] geneID)
PREFIX=$4	# output prefix
K=$5		# number of cluster


# Step1: prepare kernel matrix by running hotnet2 script
# https://github.com/raphael-group/hotnet2
# DO unzip hotnet2.tgz before use this script
# Please check the python module requirement from hotnet2 github
python ./bin/createPPRMat.py -e ${EDGELIST} -i ${IDX} -p ${PREFIX} -b ${B} -o output_${B} -f matlab
# NOTE: output directory would be named as "output_B", e.g. "output_0.5/"


# Step2: do a diffusion for each cell-type specific input
for CELL in dNPC dneuron vNPC vneuron
do

	inmat=output_${B}/string9_ppr_${B}.mat			# input kernel
	inval=input_values/${CELL}_mrnaclip_diffused.txt	# input node-diffused value file
	outmat=${CELL}_mrnaclip_diffused.rownormEV.${K}.txt	# result eigenvector matrix

	echo " - ${inval} -> ${outmat}"
        matlab -r get_eigvecmat\(\'${inmat}\',\'${inval}\',\'${K}\',\'${outmat}\'\)

done
