function get_eigvecmat(inmat,inval,k,outmat)

mat = load(inmat);
val = importdata(inval);
genes=val.textdata;
val = diag(val.data);

% value diffusion
res = mat.PPR*val;
res = res + res';

% changing into affinity
dmat = squareform(pdist(res));
smat = exp(-(dmat).^2 ./ (2*(std2(dmat))^2));

% calculation of Laplacian matrix
rng('shuffle');
for i=1:length(smat)
        smat(i,i)=0;       % change diagonal item as 0
end
dd = sum(smat);            % making diagonal matrix
dd = sum(smat) + mean(dd); % adding mean
dd(dd==0)=1;
D = diag(dd);              % make as diagonal matrix again
L = eye(size(D,1)) - (D^-.5)*smat*(D^-.5);

% calculation of eigenvector matrix
k
[V,D] = eigs(L,k,'SM');

% row normalization of eigenvector matrix
TEV = V(:,(1:k));
EV = TEV;
for j=1:size(TEV,1)
        EV(j,:) = TEV(j,:)/norm(TEV(j,:));
end

% print out
strout = strcat(outmat);
result_eigvec=table(genes, EV);
writetable(result_eigvec,strout,'Delimiter','\t','WriteVariableNames',false);


quit

