#!/bin/bash
# Use Regularized Laplacian Kernel to diffuse from FMRP hits from different data modalities
# chasman@cs.wisc.edu	Feb 2018
#
# Usage:
# bash rank_genes.sh
# 
# Get scores for all nodes - high confidence queries
# "headless" network file has no header row.
set -u

lam=$1	# lambda parameter (e.g. 0.1, 1, 5)


# human string network
bgnet=string9_undirected_sans_ubi_for_diffusion
bgfn=string9/string9_undirected_sans_ubi_for_diffusion.txt

# for each hit set, generate the results file
for cell in dNPC dneuron vNPC vneuron
do
for data in clip mrna
do
for hits in ${cell}_${data}
do
	# make score file
	OUT=results/${hits}
	hfn=inputs/${hits}_hits.txt
	hitfn=$hfn
	
	echo $hfn
	if [ ! -d ${OUT} ]; then
		mkdir -p ${OUT}
		echo "Made output directory $OUT"
	else
		echo "Output directory $OUT already exists; we probably already did this analysis."
		#continue
	fi

	# kernel
	kern=string9/${bgnet}_kernel_${lam}.npy
	echo $kern
	if [[ ! -f $kern ]]; then
		echo "Making new kernel file"
		python reg_laplacian/get_kernel_scores.py ${hfn} ${bgfn} ${lam} --crossval ${OUT}/${hits}_${bgnet}_${lam}_crossval.tab --col="0 1"
	else
		echo "Restoring existing kernel file $kern"	
		python reg_laplacian/get_kernel_scores.py ${hfn} ${bgfn} ${lam} ${kern} --crossval ${OUT}/${hits}_${bgnet}_${lam}_crossval.tab --col="0 1"
	fi	
	
	# also get scores for non held aside
	python reg_laplacian/get_kernel_scores.py ${hfn} ${bgfn} ${lam} ${kern}  ${OUT}/${hits}_${bgnet}_${lam}.tab --col="0 1"

	# rank non-hits
	python reg_laplacian/rank_unknown.py ${OUT}/${hits}_${bgnet}_${lam}.tab  > ${OUT}/${hits}_${bgnet}_${lam}_ranked.tab
		
done # done hits

done
done

