#!/bin/sh
set -u

k=45	# number of cluster
p=0.8   # transition probability (default:0.8)
x=0.01	# fixed covariance (default:0.01)
ID=$1	# run ID (e.g. 01)


orderf=orders.NPC_neuron.txt
ogidsf=OGID_1810.txt
treef=tree.NPC_neuron.txt
outdir=arb-hic_k${k}_i${ID}
configf=configs/config_k${k}.txt
best=dNPC	# defalt best_known sibling. You can ignore this.

i=1
while [[ $i -lt 2 ]]
do

./arboretum-hic/arboretum_hic -s ${orderf} -e ${ogidsf} -k ${k} -t ${treef} -c ${configf} -r rand -o ${outdir} -m learn -b ${best} -i uniform -p ${p} -x ${x} -w true -f true

check="${outdir}/allspecies_clusterassign_lca_brk.txt"
if [ -f "$check" ]
then
	((i = i + 1))
fi

done

