** Main program **
** Make sure all hits are included.
** Minimize intermediate nodes.
** Choose intermediates by maximizing the sum of their diffusion score.
** Fill in paths
** Version 2 (with diffusion score)


$offlisting
option
        limrow=0,
        limcol=0;

* Load data file
$phantom null
$Include vNPC_p2.gms

alias (node,node1);

* Load model file
$Include base_model.gms

** Minimize total nodes subject to including all hits
Model minNodeModel /all/ ;
minNodeModel.optca=0;
minNodeModel.optcr=0;
minNodeModel.reslim=100000;
minNodeModel.optfile=1;

** Constrain node count
Scalar minNodeCount "minimal node count" /0/;
Equation fixNodeCount "Set number of nodes";
fixNodeCount .. nodeCount =l= minNodeCount;

** Count up the score of active nodes
Free Variable
	totalScore	"Sum of scores for nodes";
Equation computeNodeScore	"Tally up node scores for active nodes";
computeNodeScore .. totalScore =e= sum(diffusionFeatureN(node), y(node)*diffusionParamN(node));

Model maxScoreModel /all/ ;
maxScoreModel.optca=0;
maxScoreModel.optcr=0;
maxScoreModel.reslim=100000;
maxScoreModel.optfile=1;

** Finally, maximize paths to improve interpretation.
** At this point we will have fixed the node selection.
Model maxPathModel /all/ ;
maxPathModel.optcr=0;
maxPathModel.optca=0;
maxPathModel.reslim=100000;
maxPathModel.optfile=1;

Set 	soln 	possible solutions in the solution pool 
	/file1/;

* STEP 1: Must include all hits (fix the y value).
y.fx(hitValueN(node))=1;

* STEP 2: Identify minimum node count
solve minNodeModel using mip min nodeCount;

* Identify min node count so it can be used in the next solve
minNodeCount=nodeCount.l;

* STEP 3: Maximize score of intermediate nodes
solve maxScoreModel using mip max totalScore;

* STEP 4: Fix the y settings and then fill in the paths.
Set solNode(node)	"nodes on in a solution";
solNode(node)=no;
solNode(node)$(y.l(node)>0)=yes;
	
y.fx(node)=0;
y.fx(solNode)=1;	
	
solve maxPathModel using mip max pathCount;

* Write results to gdx file
file fsol;
put fsol;
put_utility 'gdxout' / 'final.gdx';
execute_unload sigma,x,y;	
