#!/bin/bash
# Sets up a run in a directory of your choice.
# Add a directory name of your choice.
# You will then descend into that directory to run GAMS on the model.
# USAGE: ./set_up.sh condition runtype outdir

if [[ $# != 1 ]]; then
	echo "USAGE: ./set_up_local.sh condition"
	exit
fi

cond=$1

wd=$(pwd)

datafile=${wd}/${cond}/${cond}.gms
if [[ ! -e $datafile ]]; then
	echo "Cannot find data file $datafile"
	exit 2
fi

template=${wd}/model/run_template_v2.gms
if [[ ! -e $template ]]; then
	echo "Cannot find template gams file $template"
	exit 2
fi

outdir=${cond}/gams_run
if [[ -d $outdir ]]; then
	echo "$outdir already exists."
	exit 2
fi

#########

# make directory and copy in relevant stuff -- template, base model, and CPLEX options
# We might need to move this directory somewhere else for running on opt cluster
mkdir -p $outdir
dbase=$(basename $datafile)
sed "s:{DATA}:${dbase}:" $template > ${outdir}/run_${cond}.gms
cp ${datafile} ${outdir}
cp model/base_model.gms ${outdir}
cp model/cplex* ${outdir}

echo "Directory $outdir is ready for you to run GAMS on ${outdir}/run_${cond}.gms"

