#!/bin/bash
# Processes gams output files into confidence files and cytoscape-friendly files
# Args: top dir of analysis, name of path contents file (eg, data/nacl_v2_all_paths.tab),
#	prefix for output files
# Source nodes hard-coded for NaCl and DTT 
# You should call this script from a parent directory that contains the script directory AND gams output directory

set -u

if [[ $# != 1 ]]; then
	echo "USAGE: bash scripts/process.sh condition"
	echo "condition is the name of the experiment you ran (matches the config filename and output rdir)"
	echo "the directory ${condition}/ must contain your gams_run directory and the ${condition}_paths.tab file."
	exit 2
fi
cond=$1
topdir=${cond}/gams_run
pathfile=${cond}/${cond}_paths.tab
prefix=final

wd=$(pwd)
cd $topdir

if [[ ! -e ${wd}/scripts/add_path_confs.py ]]; then
	echo "Cannot find scripts for processing -- you should call this program from above the scripts directory (or update the paths)"
	exit
fi	

for d in gdx result cyto; do
	if [[ ! -d $d ]]; then
		mkdir $d
	fi
done

mv *.gdx gdx
# CHECK SCRIPT PATHS HERE...
echo "Deleting existing dump files"
echo $(pwd)
rm -f result/*_dump

inpref=""
for fn in `ls gdx/${prefix}*gdx`
do
	echo $fn
	f=${fn##*/}  # remove path
	f=${f%.*} # remove extension
	inpref=$f
	if [[ "$inpref" == "solnpool" ]]; then
		continue
	fi
	for i in sigma x y 
	do
		/progs/gams-old/current/gdxdump gdx/${f}.gdx symb=${i} Format=csv | grep -v ",0" | grep -v "Val" | awk -v i="${i}" -F"," '{print i"\t"$1"\t"$2}' >> result/${f}_dump
	done	
done

python ${wd}/scripts/gather_path_solution_info.py "result/${prefix}*_dump" result/${prefix}
python ${wd}/scripts/add_path_confs.py ${wd}/${pathfile} result/${prefix}_sigma.tab > cyto/${prefix}_paths_with_confs.tab 

for f in 0.50 0.75; do
	python ${wd}/scripts/make_sif_update.py cyto/${prefix}_paths_with_confs.tab $f > cyto/${prefix}_${f}.sif
	echo "Made ${topdir}/cyto/${prefix}_${f}.sif"
done

cd $wd
