#!/bin/bash
set -u

if [[ $# != 1 ]]; then
	echo "Usage: 1run_pathfinder.sh condition"
	echo "Current conditions: [celltype]_p[1/2], (e.g. dNPC_p1)"
	exit
fi

cond=$1
outdir=${cond}

echo "Running pathfinding for $cond"

if [ ! -d ${outdir} ]; then
	mkdir ${outdir}
fi
	
# pathfinder is same jar that we used for influenza project
java -jar pathfinder.jar configs/${cond}.config > run_${cond}_pathfinder.log
date
