** Main program **
** Maximize included hits
** Minimize intermediate nodes
** Fill in paths
** Version 1: Just find one solution.


$offlisting
option
        limrow=0,
        limcol=0;

* Load data file
$phantom null
$Include {DATA}

alias (node,node1);

* Load model file
$Include base_model.gms

* Maximize included hit genes (from any data type)
Free variable hitCount        "total hits included";
Equation countHits     "count up active hits edges";
countHits .. hitCount =l= sum(hitValueN(node), y(node));

Model maxHitModel /all/;
maxHitModel.optcr=0.0;
maxHitModel.optca=0.0;
maxHitModel.reslim=100000;
maxHitModel.optfile=1;

* Fix the value
Scalar maxHits "max matches calculated"	/0/;

Equation fixHitCount "Set hits active within tolerance (exact)";
fixHitCount .. hitCount =g= 1.0*maxHits;

** Minimize remaining nodes 
Model minNodeModel /all/ ;
minNodeModel.optca=0;
minNodeModel.optcr=0;
minNodeModel.reslim=100000;
minNodeModel.optfile=1;

** Finally, maximize paths to improve interpretation.
Model maxPathModel /all/ ;
maxPathModel.optcr=0;
maxPathModel.optca=0;
maxPathModel.reslim=100000;
maxPathModel.optfile=1;

Set 	soln 	possible solutions in the solution pool 
	/file1/;

* Just get one solution
solve maxHitModel using mip max hitCount;

maxHits=hitCount.l;
solve minNodeModel using mip min nodeCount;

* Fix the y settings and then fill in the paths.
Set solNode(node)	"nodes on in a solution";
solNode(node)=no;
solNode(node)$(y.l(node)>0)=yes;
	
y.fx(node)=0;
y.fx(solNode)=1;	
	
solve maxPathModel using mip max pathCount;

* Write results to gdx file
file fsol;
put fsol;
put_utility 'gdxout' / 'final.gdx';
execute_unload sigma,x,y;	
