/*
 * Decompiled with CFR 0.152.
 */
package utilities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;

public class StringUtils {
    public static <T> String join(Collection<T> col, String delim) {
        StringBuilder sb = new StringBuilder();
        Iterator<T> iter = col.iterator();
        if (iter.hasNext()) {
            sb.append(iter.next().toString());
            while (iter.hasNext()) {
                sb.append(String.format("%s%s", delim, iter.next().toString()));
            }
        }
        return sb.toString();
    }

    public static <T> String sortJoin(Collection<T> col, String delim) {
        ArrayList<String> colList = new ArrayList<String>();
        for (T item : col) {
            colList.add(item.toString());
        }
        Collections.sort(colList);
        return StringUtils.join(colList, delim);
    }
}

