/*
 * Decompiled with CFR 0.152.
 */
package utilities;

import filters.Filter;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import structures.Continuous;
import structures.Discrete;
import structures.Edge;
import structures.EdgeLibrary;
import structures.Feature;
import structures.Graph;
import structures.NodeLibrary;
import structures.Value;

public class GraphUtils {
    public static Set<String> request(Graph g, NodeLibrary libe, Feature f) {
        HashSet<String> nodes = new HashSet<String>(libe.get(f));
        if (g != null && g.nodes() != null) {
            nodes.retainAll(g.nodes());
            return nodes;
        }
        return new HashSet<String>();
    }

    public static Set<Edge> request(Graph g, EdgeLibrary libe, Feature f) {
        HashSet<Edge> edges = new HashSet<Edge>(libe.get(f));
        edges.retainAll(g.edges());
        return edges;
    }

    public static Graph filter(Graph orig, Filter filter, NodeLibrary libe) {
        HashSet<String> keepNodes = new HashSet<String>();
        for (String n : orig.nodes()) {
            if (!filter.accept(libe.getValue(n, filter.feature()))) continue;
            keepNodes.add(n);
        }
        Graph copy = orig.restrict(keepNodes);
        return copy;
    }

    public static Graph filterAnd(Graph orig, Collection<Filter> filters, NodeLibrary libe) {
        HashSet<String> keepNodes = new HashSet<String>();
        for (String n : orig.nodes()) {
            boolean keep = true;
            for (Filter filter : filters) {
                if (filter.accept(libe.getValue(n, filter.feature()))) continue;
                keep = false;
            }
            if (!keep) continue;
            keepNodes.add(n);
        }
        Graph copy = orig.restrict(keepNodes);
        return copy;
    }

    public static Graph filterOr(Graph orig, Collection<Filter> filters, NodeLibrary libe) {
        HashSet<String> keepNodes = new HashSet<String>();
        for (String n : orig.nodes()) {
            boolean keep = false;
            for (Filter filter : filters) {
                if (!filter.accept(libe.getValue(n, filter.feature()))) continue;
                keep = true;
            }
            if (!keep) continue;
            keepNodes.add(n);
        }
        Graph copy = orig.restrict(keepNodes);
        return copy;
    }

    public static Value getValue(String node, Feature feat, Graph g) {
        GraphFeature gf = GraphFeature.valueOf(feat.name().toUpperCase());
        assert (gf != null) : "Request for unimplemented graph feature " + feat.name();
        switch (gf) {
            case DEGREE: {
                return GraphUtils.getDegree(node, g);
            }
        }
        return null;
    }

    protected static Value getDegree(String node, Graph g) {
        Continuous deg = Continuous.makeValue(g.degree(node));
        return deg;
    }

    public static Value getValue(Edge edge, Feature feat, Graph g) {
        GraphFeature gf = GraphFeature.valueOf(feat.name().toUpperCase());
        assert (gf != null) : "Request for unimplemented graph feature " + feat.name();
        switch (gf) {
            case SELF_LOOP: {
                return GraphUtils.getIsSelfLoop(edge, g);
            }
        }
        return null;
    }

    protected static Value getIsSelfLoop(Edge edge, Graph g) {
        Discrete val = Discrete.makeValue(Boolean.toString(edge.isSelfLoop()).toLowerCase());
        return val;
    }

    public static enum Element {
        NODE,
        EDGE;

    }

    public static enum GraphFeature {
        DEGREE(Element.NODE),
        SELF_LOOP(Element.EDGE);

        private final Element el;
        private final Feature feature;

        private GraphFeature(Element el) {
            this.el = el;
            this.feature = GraphFeature.buildFeature(this.name());
        }

        private static Feature buildFeature(String type) {
            if (type.equals("DEGREE")) {
                return new Feature("degree", Value.Type.CONTINUOUS, new Value[]{Continuous.makeValue(0.0), Continuous.makeValue(Double.MAX_VALUE)}, "graph node degree", "calculated from graph");
            }
            if (type.equals((Object)SELF_LOOP)) {
                return new Feature("self_loop", Value.Type.DISCRETE, new Value[]{Discrete.makeValue("true"), Discrete.makeValue("false")}, "is edge self loop", "calculated from graph");
            }
            return null;
        }

        public Element element() {
            return this.el;
        }

        public Feature feature() {
            return this.feature;
        }
    }
}

