/*
 * Decompiled with CFR 0.152.
 */
package utilities;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Scanner;
import java.util.Set;
import structures.Pair;

public class GenUtils {
    public static <T extends Comparable<T>> Set<Pair<T, T>> allPairs(Set<T> input) {
        HashSet<Pair<T, T>> pairs = new HashSet<Pair<T, T>>();
        ArrayList<T> inlist = new ArrayList<T>(input);
        Collections.sort(inlist);
        int i = 0;
        while (i < inlist.size()) {
            int j = i + 1;
            while (j < inlist.size()) {
                Pair<Comparable, Comparable> p = new Pair<Comparable, Comparable>((Comparable)inlist.get(i), (Comparable)inlist.get(j));
                pairs.add(p);
                ++j;
            }
            ++i;
        }
        return pairs;
    }

    public static Set<String> readFileSet(String filename, String comment) throws FileNotFoundException {
        Scanner s = null;
        HashSet<String> found = new HashSet<String>();
        try {
            s = new Scanner(new File(filename));
            while (s.hasNext()) {
                String line = s.nextLine().trim();
                if (line.startsWith(comment)) continue;
                found.add(line);
            }
        }
        catch (FileNotFoundException fnfe) {
            throw new FileNotFoundException("Unable to read strings from requested file " + filename);
        }
        return found;
    }

    public static <T> double jaccard(Set<T> a, Set<T> b) {
        HashSet<T> intersect = new HashSet<T>(a);
        intersect.retainAll(b);
        HashSet<T> union = new HashSet<T>(a);
        union.addAll(b);
        double i = 1.0 * (double)intersect.size();
        double u = 1.0 * (double)union.size();
        return i / u;
    }
}

