/*
 * Decompiled with CFR 0.152.
 */
package utilities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GamsUtils {
    public static String gamsCleanse(String name) {
        String newName = name.replaceAll("[^A-Za-z0-9]", "");
        return newName;
    }

    public static String makeSetList(String setName, String setDescr, Collection<String> strs, int cols) {
        if (strs.size() == 0) {
            return GamsUtils.makeEmpty(setName, setDescr);
        }
        StringBuilder sb = new StringBuilder();
        setDescr = setDescr.replace("\"", "");
        sb.append(String.format("Set %s\t\"%s (%d)\"\n\t/ ", setName, setDescr, strs.size()));
        boolean lineStart = true;
        strs = GamsUtils.makeCollapsedIDSet(strs);
        ArrayList<String> strings = new ArrayList<String>(strs);
        Collections.sort(strings);
        int i = 0;
        while (i < strings.size()) {
            String n = strings.get(i);
            sb.append(String.format("%s %s", lineStart ? "" : ",", n));
            if ((i + 1) % cols == 0 && i < strings.size() - 1) {
                sb.append(",\n\t");
                lineStart = true;
            } else {
                lineStart = false;
            }
            ++i;
        }
        sb.append(" /; \n\n");
        return sb.toString();
    }

    protected static String makeEmpty(String setName, String setDescr) {
        int size = setName.split(",").length;
        StringBuilder nulls = new StringBuilder("null");
        while (size > 1) {
            nulls.append(".null");
            --size;
        }
        setDescr = setDescr.replace("\"", "");
        String empty = String.format("Set %s\t\"%s\"\t/ %s /;\n", setName, setDescr, nulls.toString());
        return empty;
    }

    protected static String makeTupleSet(String setName, String setDescr, HashMap<String, HashSet<String>> map, int cols) {
        ArrayList<String> tuples = new ArrayList<String>();
        for (String key : map.keySet()) {
            if (map.get(key).size() == 0) continue;
            String tup = GamsUtils.pathTuple(key, (Collection<String>)map.get(key), 20);
            tuples.add(tup);
        }
        return GamsUtils.makeSetList(setName, setDescr, tuples, cols);
    }

    protected static String pathTuple(String first, Collection<String> others, int col) {
        HashSet<String> oset = new HashSet<String>(GamsUtils.makeCollapsedIDSet(others));
        ArrayList<String> olist = new ArrayList<String>(oset);
        Collections.sort(olist);
        String list = olist.get(0);
        int i = 1;
        while (i < olist.size()) {
            list = i % col == 0 ? String.valueOf(list) + ", \n" + olist.get(i) : String.valueOf(list) + ", " + olist.get(i);
            ++i;
        }
        String tup = String.format("%s.(%s)", first, list);
        return tup;
    }

    public static HashSet<String> makeCollapsedIDSet(Collection<String> ids) {
        Pattern p = Pattern.compile("(\\d+)$");
        HashMap seen = new HashMap();
        HashSet<String> noPrefix = new HashSet<String>();
        for (String id : ids) {
            Matcher m = p.matcher(id);
            if (!m.find() || id.contains(".")) {
                noPrefix.add(id);
                continue;
            }
            String num = m.group(1);
            if (num.startsWith("0") && num.length() > 1) {
                noPrefix.add(id);
                continue;
            }
            int line = Integer.parseInt(num);
            String dataset = id.substring(0, m.start(1));
            if (!seen.keySet().contains(dataset)) {
                seen.put(dataset, new ArrayList());
            }
            ((ArrayList)seen.get(dataset)).add(line);
        }
        HashSet prefices = new HashSet();
        prefices.addAll(seen.keySet());
        HashSet<String> all = new HashSet<String>();
        for (String prefix : prefices) {
            ArrayList<String> items = GamsUtils.getCollapsedList(prefix, (ArrayList)seen.get(prefix));
            all.addAll(items);
        }
        all.addAll(noPrefix);
        return all;
    }

    protected static String makeParameter(String name, String descr, Map<String, Double> values) {
        StringBuilder sb = new StringBuilder();
        descr = descr.replace("\"", "");
        sb.append(String.format("Parameter %s\t\"%s (%d)\" ", name, descr, values.size()));
        if (values.size() == 0) {
            sb.append("; \n");
        } else {
            sb.append("/");
            for (Map.Entry<String, Double> val : values.entrySet()) {
                sb.append(String.format("\n\t%s\t%s", val.getKey(), val.getValue()));
            }
            sb.append("\n/;\n");
        }
        return sb.toString();
    }

    protected static ArrayList<String> getCollapsedList(String prefix, ArrayList<Integer> numbers) {
        int j;
        ArrayList<String> collapsed = new ArrayList<String>();
        if (numbers.size() <= 2) {
            for (Integer num : numbers) {
                String newItem = String.format("%s%d", prefix, num);
                collapsed.add(newItem);
            }
            return collapsed;
        }
        Collections.sort(numbers);
        int start = numbers.get(0);
        int si = 0;
        int i = 1;
        i = 1;
        while (i < numbers.size()) {
            if (numbers.get(i) > numbers.get(i - 1) + 1) {
                if (si < i - 2) {
                    collapsed.add(String.format("%s%d*%s%d", prefix, start, prefix, numbers.get(i - 1)));
                } else {
                    j = si;
                    while (j < i) {
                        collapsed.add(String.format("%s%d", prefix, numbers.get(j)));
                        ++j;
                    }
                }
                start = numbers.get(i);
                si = i;
            }
            ++i;
        }
        if (si >= numbers.size() - 3) {
            j = si;
            while (j < numbers.size()) {
                String newItem = String.format("%s%d", prefix, numbers.get(j));
                collapsed.add(newItem);
                ++j;
            }
        } else {
            String newItem = String.format("%s%d*%s%d", prefix, start, prefix, numbers.get(numbers.size() - 1));
            collapsed.add(newItem);
        }
        return collapsed;
    }
}

